/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.DeferExpressionDimensions;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnProcessorFactory;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.nested.NestedVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class QueryableIndexVectorColumnSelectorFactory
implements VectorColumnSelectorFactory {
    private final VirtualColumns virtualColumns;
    private final ReadableVectorOffset offset;
    private final ColumnSelector columnSelector;
    private final Map<DimensionSpec, SingleValueDimensionVectorSelector> singleValueDimensionSelectorCache;
    private final Map<DimensionSpec, MultiValueDimensionVectorSelector> multiValueDimensionSelectorCache;
    private final Map<String, VectorValueSelector> valueSelectorCache;
    private final Map<String, VectorObjectSelector> objectSelectorCache;

    public QueryableIndexVectorColumnSelectorFactory(ReadableVectorOffset offset, ColumnSelector columnSelector, VirtualColumns virtualColumns) {
        this.offset = offset;
        this.virtualColumns = virtualColumns;
        this.columnSelector = columnSelector;
        this.singleValueDimensionSelectorCache = new HashMap<DimensionSpec, SingleValueDimensionVectorSelector>();
        this.multiValueDimensionSelectorCache = new HashMap<DimensionSpec, MultiValueDimensionVectorSelector>();
        this.valueSelectorCache = new HashMap<String, VectorValueSelector>();
        this.objectSelectorCache = new HashMap<String, VectorObjectSelector>();
    }

    @Override
    public ReadableVectorInspector getReadableVectorInspector() {
        return this.offset;
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
        if (!dimensionSpec.canVectorize()) {
            throw new ISE("DimensionSpec[%s] cannot be vectorized", dimensionSpec);
        }
        Function<DimensionSpec, MultiValueDimensionVectorSelector> mappingFunction = spec -> {
            if (this.virtualColumns.exists(spec.getDimension())) {
                return this.virtualColumns.makeMultiValueDimensionVectorSelector(dimensionSpec, this, this.columnSelector, this.offset);
            }
            ColumnHolder holder = this.columnSelector.getColumnHolder(spec.getDimension());
            if (holder == null || holder.getCapabilities().isDictionaryEncoded().isFalse() || !holder.getCapabilities().is(ValueType.STRING) || holder.getCapabilities().hasMultipleValues().isFalse()) {
                throw new ISE("Column[%s] is not a multi-value string column, do not ask for a multi-value selector", spec.getDimension());
            }
            DictionaryEncodedColumn dictionaryEncodedColumn = (DictionaryEncodedColumn)holder.getColumn();
            assert (dictionaryEncodedColumn != null);
            MultiValueDimensionVectorSelector selector = dictionaryEncodedColumn.makeMultiValueDimensionVectorSelector(this.offset);
            return spec.decorate(selector);
        };
        MultiValueDimensionVectorSelector selector = this.multiValueDimensionSelectorCache.get(dimensionSpec);
        if (selector == null) {
            selector = mappingFunction.apply(dimensionSpec);
            this.multiValueDimensionSelectorCache.put(dimensionSpec, selector);
        }
        return selector;
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
        if (!dimensionSpec.canVectorize()) {
            throw new ISE("DimensionSpec[%s] cannot be vectorized", dimensionSpec);
        }
        Function<DimensionSpec, SingleValueDimensionVectorSelector> mappingFunction = spec -> {
            NestedVectorColumnSelectorFactory nestedColumnSelectorFactory;
            String name = spec.getDimension();
            if (this.virtualColumns.exists(name)) {
                return this.virtualColumns.makeSingleValueDimensionVectorSelector(dimensionSpec, this, this.columnSelector, this.offset);
            }
            ColumnHolder holder = this.columnSelector.getColumnHolder(name);
            if (holder == null || !holder.getCapabilities().isDictionaryEncoded().isTrue() || !holder.getCapabilities().is(ValueType.STRING)) {
                return NilVectorSelector.create(this.offset);
            }
            if (holder.getCapabilities().hasMultipleValues().isMaybeTrue()) {
                throw new ISE("Column[%s] is multi-value, do not ask for a single-value selector", name);
            }
            BaseColumn column = (BaseColumn)holder.getColumn();
            SingleValueDimensionVectorSelector selector = column instanceof DictionaryEncodedColumn ? ((DictionaryEncodedColumn)column).makeSingleValueDimensionVectorSelector(this.offset) : ((nestedColumnSelectorFactory = column.as(NestedVectorColumnSelectorFactory.class)) != null ? nestedColumnSelectorFactory.makeSingleValueDimensionVectorSelector(List.of(), this, this.offset) : NilVectorSelector.create(this.offset));
            return spec.decorate(selector);
        };
        SingleValueDimensionVectorSelector selector = this.singleValueDimensionSelectorCache.get(dimensionSpec);
        if (selector == null) {
            selector = mappingFunction.apply(dimensionSpec);
            this.singleValueDimensionSelectorCache.put(dimensionSpec, selector);
        }
        return selector;
    }

    @Override
    public VectorValueSelector makeValueSelector(String columnName) {
        Function<String, VectorValueSelector> mappingFunction = name -> {
            if (this.virtualColumns.exists(columnName)) {
                return this.virtualColumns.makeVectorValueSelector(columnName, this, this.columnSelector, this.offset);
            }
            ColumnHolder columnHolder = this.columnSelector.getColumnHolder((String)name);
            if (columnHolder == null) {
                return NilVectorSelector.create(this.offset);
            }
            BaseColumn column = (BaseColumn)columnHolder.getColumn();
            return column.makeVectorValueSelector(this.offset);
        };
        VectorValueSelector columnValueSelector = this.valueSelectorCache.get(columnName);
        if (columnValueSelector == null) {
            columnValueSelector = mappingFunction.apply(columnName);
            this.valueSelectorCache.put(columnName, columnValueSelector);
        }
        return columnValueSelector;
    }

    @Override
    public VectorObjectSelector makeObjectSelector(String columnName) {
        Function<String, VectorObjectSelector> mappingFunction = name -> {
            if (this.virtualColumns.exists(columnName)) {
                return this.virtualColumns.makeVectorObjectSelector(columnName, this, this.columnSelector, this.offset);
            }
            ColumnHolder columnHolder = this.columnSelector.getColumnHolder((String)name);
            if (columnHolder == null) {
                return NilVectorSelector.create(this.offset);
            }
            BaseColumn column = (BaseColumn)columnHolder.getColumn();
            return column.makeVectorObjectSelector(this.offset);
        };
        VectorObjectSelector columnValueSelector = this.objectSelectorCache.get(columnName);
        if (columnValueSelector == null) {
            columnValueSelector = mappingFunction.apply(columnName);
            this.objectSelectorCache.put(columnName, columnValueSelector);
        }
        return columnValueSelector;
    }

    @Override
    public GroupByVectorColumnSelector makeGroupByVectorColumnSelector(String column, DeferExpressionDimensions deferExpressionDimensions) {
        GroupByVectorColumnSelector retVal = null;
        VirtualColumn virtualColumn = this.virtualColumns.getVirtualColumn(column);
        if (virtualColumn != null) {
            retVal = virtualColumn.makeGroupByVectorColumnSelector(column, this, deferExpressionDimensions);
        }
        if (retVal == null) {
            retVal = ColumnProcessors.makeVectorProcessor(column, GroupByVectorColumnProcessorFactory.instance(), (VectorColumnSelectorFactory)this);
        }
        return retVal;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        return this.virtualColumns.getColumnCapabilitiesWithFallback(this.columnSelector, columnName);
    }
}

