/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.io.ByteBufferInputStream;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.writeout.WriteOutBytes;

public abstract class ByteBufferWriteOutBytes
extends WriteOutBytes {
    static final int BUFFER_SIZE = 65536;
    final ArrayList<ByteBuffer> buffers = new ArrayList();
    int headBufferIndex = 0;
    ByteBuffer headBuffer = this.allocateBuffer();
    long size = 0L;
    long capacity;
    boolean open = true;

    ByteBufferWriteOutBytes() {
        this.buffers.add(this.headBuffer);
        this.capacity = 65536L;
    }

    @Override
    public long size() {
        return this.size;
    }

    protected abstract ByteBuffer allocateBuffer();

    private void ensureCapacity(int len) {
        long remaining = this.capacity - this.size;
        for (long toAllocate = (long)len - remaining; toAllocate >= 0L; toAllocate -= 65536L) {
            this.buffers.add(this.allocateBuffer());
            this.capacity += 65536L;
        }
        if (this.headBuffer.remaining() == 0) {
            this.nextHead();
        }
    }

    private void nextHead() {
        ++this.headBufferIndex;
        this.headBuffer = this.buffers.get(this.headBufferIndex);
    }

    @Override
    public void write(int b) {
        this.checkOpen();
        if (this.headBuffer.remaining() == 0) {
            this.ensureCapacity(1);
        }
        this.headBuffer.put((byte)b);
        ++this.size;
    }

    @Override
    public void writeInt(int v) {
        this.checkOpen();
        if (this.headBuffer.remaining() >= 4) {
            this.headBuffer.putInt(v);
            this.size += 4L;
        } else {
            this.ensureCapacity(4);
            if (this.headBuffer.remaining() >= 4) {
                this.headBuffer.putInt(v);
                this.size += 4L;
            } else {
                this.write(v >> 24);
                this.write(v >> 16);
                this.write(v >> 8);
                this.write(v);
            }
        }
    }

    @Override
    public void write(byte[] b) {
        this.write0(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        Preconditions.checkPositionIndexes((int)off, (int)(off + len), (int)b.length);
        this.write0(b, off, len);
    }

    private void write0(byte[] b, int off, int len) {
        int headRemaining;
        this.checkOpen();
        if (this.headBuffer.remaining() < len) {
            this.ensureCapacity(len);
        }
        if (len <= (headRemaining = this.headBuffer.remaining())) {
            this.headBuffer.put(b, off, len);
        } else {
            this.headBuffer.put(b, off, headRemaining);
            int bytesLeft = len - headRemaining;
            off += headRemaining;
            while (bytesLeft > 0) {
                this.nextHead();
                this.headBuffer.put(b, off, Math.min(65536, bytesLeft));
                bytesLeft -= 65536;
                off += 65536;
            }
        }
        this.size += (long)len;
    }

    @Override
    public int write(ByteBuffer src) {
        this.checkOpen();
        int len = src.remaining();
        if (this.headBuffer.remaining() < len) {
            this.ensureCapacity(len);
        }
        int headRemaining = this.headBuffer.remaining();
        src.limit(src.position() + Math.min(headRemaining, len));
        this.headBuffer.put(src);
        for (int bytesLeft = len - headRemaining; bytesLeft > 0; bytesLeft -= 65536) {
            this.nextHead();
            src.limit(src.position() + Math.min(65536, bytesLeft));
            this.headBuffer.put(src);
        }
        this.size += (long)len;
        return len;
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        this.checkOpen();
        for (int i = 0; i <= this.headBufferIndex; ++i) {
            ByteBuffer buffer = this.buffers.get(i);
            buffer.flip();
            Channels.writeFully(channel, buffer);
            buffer.limit(buffer.capacity());
        }
    }

    public void writeTo(ByteBuffer out) {
        this.checkOpen();
        for (int i = 0; i <= this.headBufferIndex; ++i) {
            ByteBuffer buffer = this.buffers.get(i);
            buffer.flip();
            out.put(buffer);
            buffer.limit(buffer.capacity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFully(long pos, ByteBuffer buffer) {
        int bytesToWrite;
        this.checkOpen();
        if (pos < 0L || pos > this.size) {
            throw new IAE("pos %d out of range [%d, %d]", pos, 0, this.size);
        }
        int ourBufferIndex = Ints.checkedCast((long)(pos / 65536L));
        int ourBufferOffset = Ints.checkedCast((long)(pos % 65536L));
        for (int bytesLeft = buffer.remaining(); bytesLeft > 0; bytesLeft -= bytesToWrite) {
            ByteBuffer ourBuffer;
            int ourBufferPosition;
            bytesToWrite = Math.min(65536 - ourBufferOffset, bytesLeft);
            if (bytesToWrite > (ourBufferPosition = (ourBuffer = this.buffers.get(ourBufferIndex)).position()) - ourBufferOffset) {
                throw new BufferUnderflowException();
            }
            try {
                ourBuffer.position(ourBufferOffset);
                ourBuffer.limit(ourBufferOffset + bytesToWrite);
                buffer.put(ourBuffer);
            }
            finally {
                ourBuffer.limit(ourBuffer.capacity());
                ourBuffer.position(ourBufferPosition);
            }
            ++ourBufferIndex;
            ourBufferOffset = 0;
        }
    }

    @Override
    public InputStream asInputStream() throws IOException {
        this.checkOpen();
        Function<ByteBuffer, ByteSource> byteBufferToByteSource = buf -> new ByteSource((ByteBuffer)buf){
            final /* synthetic */ ByteBuffer val$buf;
            {
                this.val$buf = byteBuffer;
            }

            public InputStream openStream() {
                ByteBuffer inputBuf = this.val$buf.duplicate();
                inputBuf.flip();
                return new ByteBufferInputStream(inputBuf);
            }
        };
        return ByteSource.concat((Iterable)this.buffers.stream().map(byteBufferToByteSource).collect(Collectors.toList())).openStream();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public void free() {
        this.open = false;
        this.buffers.clear();
        this.headBufferIndex = -1;
        this.headBuffer = null;
        this.size = 0L;
        this.capacity = 0L;
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
    }
}

