/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask;

import java.io.IOException;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.nativetask.NativeRuntime;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatusReportChecker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(StatusReportChecker.class);
    public static final int INTERVAL = 1000;
    private Thread checker;
    private final Task.TaskReporter reporter;
    private final long interval;

    public StatusReportChecker(Task.TaskReporter reporter) {
        this(reporter, 1000L);
    }

    public StatusReportChecker(Task.TaskReporter reporter, long interval) {
        this.reporter = reporter;
        this.interval = interval;
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("StatusUpdater thread exiting since it got interrupted");
                break;
            }
            try {
                NativeRuntime.reportStatus(this.reporter);
            }
            catch (IOException e) {
                LOG.warn("Update native status got exception", (Throwable)e);
                this.reporter.setStatus(e.toString());
                break;
            }
        }
    }

    protected void initUsedCounters() {
        this.reporter.getCounter((Enum)TaskCounter.MAP_INPUT_RECORDS);
        this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
        this.reporter.getCounter((Enum)FileInputFormatCounter.BYTES_READ);
        this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES);
        this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_MATERIALIZED_BYTES);
        this.reporter.getCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS);
        this.reporter.getCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS);
        this.reporter.getCounter((Enum)TaskCounter.SPILLED_RECORDS);
    }

    public synchronized void start() {
        if (this.checker == null) {
            this.initUsedCounters();
            this.checker = new Thread(this);
            this.checker.setDaemon(true);
            this.checker.start();
        }
    }

    public synchronized void stop() throws InterruptedException {
        if (this.checker != null) {
            this.checker.interrupt();
            this.checker.join();
        }
    }
}

