/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.handlers;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.nativetask.Command;
import org.apache.hadoop.mapred.nativetask.CommandDispatcher;
import org.apache.hadoop.mapred.nativetask.DataChannel;
import org.apache.hadoop.mapred.nativetask.ICombineHandler;
import org.apache.hadoop.mapred.nativetask.INativeHandler;
import org.apache.hadoop.mapred.nativetask.NativeBatchProcessor;
import org.apache.hadoop.mapred.nativetask.TaskContext;
import org.apache.hadoop.mapred.nativetask.handlers.BufferPusher;
import org.apache.hadoop.mapred.nativetask.handlers.CombinerHandler;
import org.apache.hadoop.mapred.nativetask.util.NativeTaskOutput;
import org.apache.hadoop.mapred.nativetask.util.OutputUtil;
import org.apache.hadoop.mapred.nativetask.util.ReadWriteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NativeCollectorOnlyHandler<K, V>
implements CommandDispatcher,
Closeable {
    public static final String NAME = "NativeTask.MCollectorOutputHandler";
    private static final Logger LOG = LoggerFactory.getLogger(NativeCollectorOnlyHandler.class);
    public static final Command GET_OUTPUT_PATH = new Command(100, "GET_OUTPUT_PATH");
    public static final Command GET_OUTPUT_INDEX_PATH = new Command(101, "GET_OUTPUT_INDEX_PATH");
    public static final Command GET_SPILL_PATH = new Command(102, "GET_SPILL_PATH");
    public static final Command GET_COMBINE_HANDLER = new Command(103, "GET_COMBINE_HANDLER");
    private NativeTaskOutput output;
    private int spillNumber = 0;
    private ICombineHandler combinerHandler = null;
    private final BufferPusher<K, V> kvPusher;
    private final INativeHandler nativeHandler;
    private boolean closed = false;

    public static <K, V> NativeCollectorOnlyHandler<K, V> create(TaskContext context) throws IOException {
        ICombineHandler combinerHandler = null;
        try {
            TaskContext combineContext = context.copyOf();
            combineContext.setInputKeyClass(context.getOutputKeyClass());
            combineContext.setInputValueClass(context.getOutputValueClass());
            combinerHandler = CombinerHandler.create(combineContext);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        if (null != combinerHandler) {
            LOG.info("[NativeCollectorOnlyHandler] combiner is not null");
        }
        INativeHandler nativeHandler = NativeBatchProcessor.create(NAME, (Configuration)context.getConf(), DataChannel.OUT);
        BufferPusher kvPusher = new BufferPusher(context.getOutputKeyClass(), context.getOutputValueClass(), nativeHandler);
        return new NativeCollectorOnlyHandler(context, nativeHandler, kvPusher, combinerHandler);
    }

    protected NativeCollectorOnlyHandler(TaskContext context, INativeHandler nativeHandler, BufferPusher<K, V> kvPusher, ICombineHandler combiner) throws IOException {
        JobConf conf = context.getConf();
        TaskAttemptID id = context.getTaskAttemptId();
        this.output = null == id ? OutputUtil.createNativeTaskOutput((Configuration)conf, "") : OutputUtil.createNativeTaskOutput((Configuration)context.getConf(), context.getTaskAttemptId().toString());
        this.combinerHandler = combiner;
        this.kvPusher = kvPusher;
        this.nativeHandler = nativeHandler;
        nativeHandler.setCommandDispatcher(this);
    }

    public void collect(K key, V value, int partition) throws IOException {
        this.kvPusher.collect(key, value, partition);
    }

    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (null != this.kvPusher) {
            this.kvPusher.close();
        }
        if (null != this.combinerHandler) {
            this.combinerHandler.close();
        }
        if (null != this.nativeHandler) {
            this.nativeHandler.close();
        }
        this.closed = true;
    }

    @Override
    public ReadWriteBuffer onCall(Command command, ReadWriteBuffer parameter) throws IOException {
        Path p = null;
        if (null == command) {
            return null;
        }
        if (command.equals(GET_OUTPUT_PATH)) {
            p = this.output.getOutputFileForWrite(-1L);
        } else if (command.equals(GET_OUTPUT_INDEX_PATH)) {
            p = this.output.getOutputIndexFileForWrite(-1L);
        } else if (command.equals(GET_SPILL_PATH)) {
            p = this.output.getSpillFileForWrite(this.spillNumber++, -1L);
        } else {
            if (command.equals(GET_COMBINE_HANDLER)) {
                if (null == this.combinerHandler) {
                    return null;
                }
                ReadWriteBuffer result = new ReadWriteBuffer(8);
                result.writeLong(this.combinerHandler.getId());
                return result;
            }
            throw new IOException("Illegal command: " + command.toString());
        }
        if (p != null) {
            ReadWriteBuffer result = new ReadWriteBuffer();
            result.writeString(p.toUri().getPath());
            return result;
        }
        throw new IOException("MapOutputFile can't allocate spill/output file");
    }
}

