/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestCredentialProvider {
    @Test
    public void testCredentialEntry() throws Exception {
        char[] key1 = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        CredentialProvider.CredentialEntry obj = new CredentialProvider.CredentialEntry("cred1", key1);
        Assert.assertEquals((Object)"cred1", (Object)obj.getAlias());
        Assert.assertArrayEquals((char[])new char[]{'\u0001', '\u0002', '\u0003', '\u0004'}, (char[])obj.getCredential());
    }

    @Test
    public void testUnnestUri() throws Exception {
        Assert.assertEquals((Object)new Path("hdfs://nn.example.com/my/path"), (Object)ProviderUtils.unnestUri((URI)new URI("myscheme://hdfs@nn.example.com/my/path")));
        Assert.assertEquals((Object)new Path("hdfs://nn/my/path?foo=bar&baz=bat#yyy"), (Object)ProviderUtils.unnestUri((URI)new URI("myscheme://hdfs@nn/my/path?foo=bar&baz=bat#yyy")));
        Assert.assertEquals((Object)new Path("inner://hdfs@nn1.example.com/my/path"), (Object)ProviderUtils.unnestUri((URI)new URI("outer://inner@hdfs@nn1.example.com/my/path")));
        Assert.assertEquals((Object)new Path("user:///"), (Object)ProviderUtils.unnestUri((URI)new URI("outer://user/")));
    }
}

