/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRegistryUtils.class);
    public static final String SVC_USERS = "/services/yarn/users";

    public static String registryPathForInstance(String instanceName) {
        return RegistryUtils.servicePath((String)RegistryUtils.currentUser(), (String)"yarn-service", (String)instanceName);
    }

    public static String mkServiceHomePath(String username, String serviceName) {
        return ServiceRegistryUtils.mkUserHomePath(username) + "/" + serviceName;
    }

    public static String mkUserHomePath(String username) {
        return "/services/yarn/users/" + username;
    }

    public static boolean registryDNSLookupExists(String addr, String name) {
        if (addr == null) {
            try {
                InetAddress.getByName(name);
                return true;
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        String dnsURI = String.format("dns://%s", addr);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", dnsURI);
        try {
            InitialDirContext ictx = new InitialDirContext(env);
            Attributes attrs = ictx.getAttributes(name, new String[]{"A"});
            if (attrs.size() > 0) {
                return true;
            }
        }
        catch (NameNotFoundException ictx) {
        }
        catch (NamingException e) {
            LOG.error("Got exception when performing DNS lookup", (Throwable)e);
        }
        return false;
    }
}

