/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

final class MatrixFactory<N extends Number, I extends BasicMatrix>
implements BasicMatrix.Factory<I> {
    private final Constructor<I> myConstructor;
    private final PhysicalStore.Factory<N, ?> myPhysicalFactory;

    private static Constructor<? extends BasicMatrix> getConstructor(Class<? extends BasicMatrix> aTemplate) {
        try {
            Constructor<? extends BasicMatrix> retVal = aTemplate.getDeclaredConstructor(MatrixStore.class);
            retVal.setAccessible(true);
            return retVal;
        }
        catch (SecurityException anException) {
            return null;
        }
        catch (NoSuchMethodException anException) {
            return null;
        }
    }

    MatrixFactory(Class<I> template, PhysicalStore.Factory<N, ?> factory) {
        this.myPhysicalFactory = factory;
        this.myConstructor = MatrixFactory.getConstructor(template);
    }

    public final AggregatorSet<N> aggregator() {
        return this.myPhysicalFactory.aggregator();
    }

    @Override
    public I columns(Access1D<?> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(double[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(List<? extends Number> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I columns(Number[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.columns(source));
    }

    @Override
    public I copy(Access2D<?> source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.copy(source));
    }

    public final FunctionSet<N> function() {
        return this.myPhysicalFactory.function();
    }

    @Override
    public BasicMatrix.Builder<I> getBuilder(int count) {
        return this.getBuilder(count, 1);
    }

    @Override
    public BasicMatrix.Builder<I> getBuilder(int rows, int columns) {
        return new MatrixBuilder(this.myPhysicalFactory, rows, columns);
    }

    @Override
    public I makeEye(long rows, long columns) {
        int tmpMinDim = (int)Math.min(rows, columns);
        MatrixStore.LogicalBuilder<N> retVal = this.myPhysicalFactory.builder().makeIdentity(tmpMinDim);
        if (rows > (long)tmpMinDim) {
            retVal = retVal.below((int)rows - tmpMinDim);
        } else if (columns > (long)tmpMinDim) {
            retVal = retVal.right((int)columns - tmpMinDim);
        }
        return this.instantiate((MatrixStore<N>)retVal.get());
    }

    @Override
    public I makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.makeFilled(rows, columns, supplier));
    }

    @Override
    public I makeZero(long rows, long columns) {
        return this.instantiate((MatrixStore<N>)this.myPhysicalFactory.builder().makeZero((int)rows, (int)columns).get());
    }

    @Override
    public I rows(Access1D<?> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(double[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(List<? extends Number> ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    @Override
    public I rows(Number[] ... source) {
        return this.instantiate((MatrixStore)this.myPhysicalFactory.rows(source));
    }

    public final Scalar.Factory<N> scalar() {
        return this.myPhysicalFactory.scalar();
    }

    final I instantiate(MatrixStore<N> store) {
        try {
            return (I)((BasicMatrix)this.myConstructor.newInstance(store));
        }
        catch (IllegalArgumentException anException) {
            throw new ProgrammingError(anException);
        }
        catch (InstantiationException anException) {
            throw new ProgrammingError(anException);
        }
        catch (IllegalAccessException anException) {
            throw new ProgrammingError(anException);
        }
        catch (InvocationTargetException anException) {
            throw new ProgrammingError(anException);
        }
    }

    final MatrixBuilder wrap(PhysicalStore<N> store) {
        return new MatrixBuilder(store);
    }

    final class MatrixBuilder
    implements BasicMatrix.Builder<I> {
        private final PhysicalStore<N> myStore;
        private boolean mySafe = true;

        protected MatrixBuilder(PhysicalStore.Factory<N, ?> factory, int rowDim, int colDim) {
            this.myStore = (PhysicalStore)factory.makeZero(rowDim, colDim);
        }

        MatrixBuilder(PhysicalStore<N> physicalStore) {
            this.myStore = physicalStore;
        }

        @Override
        public final void add(long row, long col, double value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.add(row, col, value);
        }

        @Override
        public final void add(long row, long col, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.add(row, col, value);
        }

        @Override
        public final long count() {
            return this.myStore.count();
        }

        @Override
        public final long countColumns() {
            return this.myStore.countColumns();
        }

        @Override
        public final long countRows() {
            return this.myStore.countRows();
        }

        public final MatrixBuilder fillAll(Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillAll(this.myStore.physical().scalar().cast(value));
            return this;
        }

        public final MatrixBuilder fillColumn(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillColumn((long)((int)row), (long)((int)column), this.myStore.physical().scalar().cast(value));
            return this;
        }

        public final MatrixBuilder fillDiagonal(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillDiagonal((long)((int)row), (long)((int)column), this.myStore.physical().scalar().cast(value));
            return this;
        }

        public final MatrixBuilder fillRow(long row, long column, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.fillRow((long)((int)row), (long)((int)column), this.myStore.physical().scalar().cast(value));
            return this;
        }

        @Override
        public final I get() {
            this.mySafe = false;
            return MatrixFactory.this.instantiate(this.myStore);
        }

        @Override
        public final void set(long index, double value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.set(index, value);
        }

        @Override
        public final void set(long row, long col, double value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.set(row, col, value);
        }

        @Override
        public final void set(long row, long col, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.set(row, col, value);
        }

        @Override
        public final void set(long index, Number value) {
            if (!this.mySafe) {
                throw new IllegalStateException();
            }
            this.myStore.set(index, (Number)this.myStore.physical().scalar().cast(value));
        }
    }
}

