/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.solver.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.skylinestore.api.PredictionSkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.solver.api.Solver;
import org.apache.hadoop.resourceestimator.solver.exceptions.SolverException;
import org.apache.hadoop.resourceestimator.solver.impl.BaseSolver;
import org.apache.hadoop.resourceestimator.solver.preprocess.SolverPreprocessor;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LpSolver
extends BaseSolver
implements Solver {
    private static final Logger LOGGER = LoggerFactory.getLogger(LpSolver.class);
    private final SolverPreprocessor preprocessor = new SolverPreprocessor();
    private double alpha;
    private double beta;
    private int minJobRuns;
    private int timeInterval;
    private PredictionSkylineStore predictionSkylineStore;

    @Override
    public final void init(Configuration config, PredictionSkylineStore skylineStore) {
        this.alpha = config.getDouble("resourceestimator.solver.lp.alpha", 0.1);
        this.beta = config.getDouble("resourceestimator.solver.lp.beta", 0.1);
        this.minJobRuns = config.getInt("resourceestimator.solver.lp.minJobRuns", 1);
        this.timeInterval = config.getInt("resourceestimator.timeInterval", 5);
        this.predictionSkylineStore = skylineStore;
    }

    private void generateOverAllocationConstraints(ExpressionsBasedModel lpModel, double cJobITimeK, Variable[] oa, Variable[] x, int indexJobITimeK, int timeK) {
        Expression overAllocExpression = lpModel.addExpression("over_alloc_" + indexJobITimeK);
        overAllocExpression.set(oa[indexJobITimeK], (Number)1);
        overAllocExpression.set(x[timeK], (Number)-1);
        overAllocExpression.lower((Number)(-cJobITimeK));
    }

    private void generateUnderAllocationConstraints(ExpressionsBasedModel lpModel, double cJobITimeK, Variable[] uaPredict, Variable[] ua, Variable[] x, int indexJobITimeK, int timeK) {
        Expression underAllocPredictExpression = lpModel.addExpression("under_alloc_predict_" + indexJobITimeK);
        underAllocPredictExpression.set(uaPredict[indexJobITimeK], (Number)1);
        underAllocPredictExpression.set(x[timeK], (Number)1);
        underAllocPredictExpression.lower((Number)cJobITimeK);
        if (timeK >= 1) {
            Expression underAllocExpression = lpModel.addExpression("under_alloc_" + indexJobITimeK);
            underAllocExpression.set(ua[indexJobITimeK], (Number)1);
            underAllocExpression.set(ua[indexJobITimeK - 1], (Number)-1);
            underAllocExpression.set(x[timeK], (Number)1);
            underAllocExpression.lower((Number)cJobITimeK);
        } else {
            Expression underAllocExpression = lpModel.addExpression("under_alloc_" + indexJobITimeK);
            underAllocExpression.set(ua[indexJobITimeK], (Number)1);
            underAllocExpression.set(x[timeK], (Number)1);
            underAllocExpression.lower((Number)cJobITimeK);
        }
    }

    private void generateObjective(Expression objective, int numJobs, int jobLen, Variable[] oa, Variable[] ua, Variable eps) {
        for (int indexJobI = 0; indexJobI < numJobs; ++indexJobI) {
            for (int timeK = 0; timeK < jobLen; ++timeK) {
                int indexJobITimeK = indexJobI * jobLen + timeK;
                objective.set(oa[indexJobITimeK], (Number)(this.alpha / (double)numJobs));
            }
        }
        for (int indexJobI = 0; indexJobI < numJobs; ++indexJobI) {
            int indexJobITimeN = indexJobI * jobLen + jobLen - 1;
            objective.set(ua[indexJobITimeN], (Number)((1.0 - this.alpha) / (double)numJobs));
        }
        objective.set(eps, (Number)this.beta);
        objective.weight((Number)BigDecimal.valueOf(1L));
    }

    private int getJobLen(List<ResourceSkyline> resourceSkylines, int numJobs) {
        int curLen = 0;
        int jobLen = 0;
        for (int indexJobI = 0; indexJobI < numJobs; ++indexJobI) {
            curLen = (int)(resourceSkylines.get(indexJobI).getSkylineList().getLatestNonNullTime() - resourceSkylines.get(indexJobI).getSkylineList().getEarliestStartTime() + (long)this.timeInterval - 1L) / this.timeInterval;
            if (jobLen >= curLen) continue;
            jobLen = curLen;
        }
        return jobLen;
    }

    @Override
    public final RLESparseResourceAllocation solve(Map<RecurrenceId, List<ResourceSkyline>> jobHistory) throws SolverException, SkylineStoreException {
        int i;
        this.preprocessor.validate(jobHistory, this.timeInterval);
        List<ResourceSkyline> resourceSkylines = this.preprocessor.aggregateSkylines(jobHistory, this.minJobRuns);
        int numJobs = resourceSkylines.size();
        int jobLen = this.getJobLen(resourceSkylines, numJobs);
        ExpressionsBasedModel lpModel = new ExpressionsBasedModel();
        Variable[] oa = new Variable[jobLen * numJobs];
        Variable[] ua = new Variable[jobLen * numJobs];
        Variable[] uaPredict = new Variable[jobLen * numJobs];
        Variable[] x = new Variable[jobLen];
        for (i = 0; i < jobLen * numJobs; ++i) {
            oa[i] = (Variable)new Variable("oa" + i).lower((Number)BigDecimal.valueOf(0L));
            ua[i] = (Variable)new Variable("ua" + i).lower((Number)BigDecimal.valueOf(0L));
            uaPredict[i] = (Variable)new Variable("uaPredict" + i).lower((Number)BigDecimal.valueOf(0L));
        }
        for (i = 0; i < jobLen; ++i) {
            x[i] = (Variable)new Variable("x").lower((Number)BigDecimal.valueOf(0L));
        }
        lpModel.addVariables(x);
        lpModel.addVariables(oa);
        lpModel.addVariables(ua);
        lpModel.addVariables(uaPredict);
        Variable eps = (Variable)new Variable("epsilon").lower((Number)BigDecimal.valueOf(0L));
        lpModel.addVariable(eps);
        int indexJobITimeK = 0;
        double cJobI = 0.0;
        double cJobITimeK = 0.0;
        Expression regularizationConstraint = lpModel.addExpression("regularization");
        regularizationConstraint.set(eps, (Number)(-numJobs));
        regularizationConstraint.upper((Number)BigDecimal.valueOf(0L));
        for (int indexJobI = 0; indexJobI < resourceSkylines.size(); ++indexJobI) {
            ResourceSkyline resourceSkyline = resourceSkylines.get(indexJobI);
            int[] containerNums = this.preprocessor.getDiscreteSkyline(resourceSkyline.getSkylineList(), this.timeInterval, resourceSkyline.getContainerSpec().getMemorySize(), jobLen);
            cJobI = 0.0;
            for (int i2 = 0; i2 < containerNums.length; ++i2) {
                cJobI += (double)containerNums[i2];
            }
            for (int timeK = 0; timeK < jobLen; ++timeK) {
                indexJobITimeK = indexJobI * jobLen + timeK;
                cJobITimeK = containerNums[timeK];
                regularizationConstraint.set(uaPredict[indexJobITimeK], (Number)(1.0 / cJobI));
                this.generateOverAllocationConstraints(lpModel, cJobITimeK, oa, x, indexJobITimeK, timeK);
                this.generateUnderAllocationConstraints(lpModel, cJobITimeK, uaPredict, ua, x, indexJobITimeK, timeK);
            }
        }
        Expression objective = lpModel.addExpression("objective");
        this.generateObjective(objective, numJobs, jobLen, oa, ua, eps);
        Optimisation.Result lpResult = lpModel.minimise();
        TreeMap treeMap = new TreeMap();
        RLESparseResourceAllocation result = new RLESparseResourceAllocation(treeMap, (ResourceCalculator)new DefaultResourceCalculator());
        Resource containerSpec = resourceSkylines.get(0).getContainerSpec();
        String pipelineId = ((RecurrenceId)jobHistory.keySet().toArray()[0]).getPipelineId();
        for (int indexTimeK = 0; indexTimeK < jobLen; ++indexTimeK) {
            ReservationInterval riAdd = new ReservationInterval((long)(indexTimeK * this.timeInterval), (long)((indexTimeK + 1) * this.timeInterval));
            Resource resource = Resource.newInstance((long)(containerSpec.getMemorySize() * (long)((int)lpResult.doubleValue((long)indexTimeK))), (int)(containerSpec.getVirtualCores() * (int)lpResult.doubleValue((long)indexTimeK)));
            result.addInterval(riAdd, resource);
            LOGGER.debug("time interval: {}, container: {}.", (Object)indexTimeK, (Object)lpResult.doubleValue((long)indexTimeK));
        }
        this.predictionSkylineStore.addEstimation(pipelineId, result);
        return result;
    }

    @Override
    public final void close() {
    }
}

