/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CalculationContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceCalculationDriver;

public class PercentageQueueCapacityCalculator
extends AbstractQueueCapacityCalculator {
    @Override
    public double calculateMinimumResource(ResourceCalculationDriver resourceCalculationDriver, CalculationContext context, String label) {
        String resourceName = context.getResourceName();
        double parentAbsoluteCapacity = resourceCalculationDriver.getParentAbsoluteMinCapacity(label, resourceName);
        double remainingPerEffectiveResourceRatio = resourceCalculationDriver.getRemainingRatioOfResource(label, resourceName);
        double absoluteCapacity = parentAbsoluteCapacity * remainingPerEffectiveResourceRatio * context.getCurrentMinimumCapacityEntry(label).getResourceValue() / 100.0;
        return (double)resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(label).getResourceValue(resourceName) * absoluteCapacity;
    }

    @Override
    public double calculateMaximumResource(ResourceCalculationDriver resourceCalculationDriver, CalculationContext context, String label) {
        String resourceName = context.getResourceName();
        double parentAbsoluteMaxCapacity = resourceCalculationDriver.getParentAbsoluteMaxCapacity(label, resourceName);
        double absoluteMaxCapacity = parentAbsoluteMaxCapacity * context.getCurrentMaximumCapacityEntry(label).getResourceValue() / 100.0;
        return (double)resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(label).getResourceValue(resourceName) * absoluteMaxCapacity;
    }

    @Override
    public void calculateResourcePrerequisites(ResourceCalculationDriver resourceCalculationDriver) {
    }

    @Override
    public void updateCapacitiesAfterCalculation(ResourceCalculationDriver resourceCalculationDriver, CSQueue queue, String label) {
        ((AbstractCSQueue)queue).updateAbsoluteCapacities();
    }

    @Override
    public QueueCapacityVector.ResourceUnitCapacityType getCapacityType() {
        return QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE;
    }
}

