/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.Set;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplicationsNamespace;

public final class AllocationTags {
    private TargetApplicationsNamespace ns;
    private Set<String> tags;
    private ApplicationId applicationId;

    private AllocationTags(TargetApplicationsNamespace namespace, Set<String> allocationTags) {
        this.ns = namespace;
        this.tags = allocationTags;
    }

    private AllocationTags(TargetApplicationsNamespace namespace, Set<String> allocationTags, ApplicationId currentAppId) {
        this.ns = namespace;
        this.tags = allocationTags;
        this.applicationId = currentAppId;
    }

    public TargetApplicationsNamespace getNamespace() {
        return this.ns;
    }

    public ApplicationId getCurrentApplicationId() {
        return this.applicationId;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    @VisibleForTesting
    public static AllocationTags createSingleAppAllocationTags(ApplicationId appId, Set<String> tags) {
        TargetApplicationsNamespace.AppID namespace = new TargetApplicationsNamespace.AppID(appId);
        return new AllocationTags(namespace, tags);
    }

    @VisibleForTesting
    public static AllocationTags createGlobalAllocationTags(Set<String> tags) {
        TargetApplicationsNamespace.All namespace = new TargetApplicationsNamespace.All();
        return new AllocationTags(namespace, tags);
    }

    @VisibleForTesting
    public static AllocationTags createOtherAppAllocationTags(ApplicationId currentApp, Set<String> tags) {
        TargetApplicationsNamespace.NotSelf namespace = new TargetApplicationsNamespace.NotSelf();
        return new AllocationTags(namespace, tags, currentApp);
    }

    public static AllocationTags createAllocationTags(ApplicationId currentApplicationId, String namespaceString, Set<String> tags) throws InvalidAllocationTagsQueryException {
        TargetApplicationsNamespace namespace = TargetApplicationsNamespace.parse(namespaceString);
        return new AllocationTags(namespace, tags, currentApplicationId);
    }
}

