/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirWriteFileOp;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.EnumSetWritable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAddBlockRetry {
    public static final Logger LOG = LoggerFactory.getLogger(TestAddBlockRetry.class);
    private static final short REPLICATION = 3;
    private Configuration conf;
    private MiniDFSCluster cluster;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetryAddBlockWhileInChooseTarget() throws Exception {
        LocatedBlock newBlock;
        FSDirWriteFileOp.ValidateAddBlockResult r;
        String src = "/testRetryAddBlockWhileInChooseTarget";
        FSNamesystem ns = this.cluster.getNamesystem();
        NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        nn.create("/testRetryAddBlockWhileInChooseTarget", FsPermission.getFileDefault(), "clientName", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)3, 1024L, null, null, null);
        LOG.info("Starting first addBlock for /testRetryAddBlockWhileInChooseTarget");
        LocatedBlock[] onRetryBlock = new LocatedBlock[1];
        ns.readLock();
        FSPermissionChecker pc = (FSPermissionChecker)Mockito.mock(FSPermissionChecker.class);
        try {
            r = FSDirWriteFileOp.validateAddBlock((FSNamesystem)ns, (FSPermissionChecker)pc, (String)"/testRetryAddBlockWhileInChooseTarget", (long)0L, (String)"clientName", null, (LocatedBlock[])onRetryBlock);
        }
        finally {
            ns.readUnlock();
        }
        DatanodeStorageInfo[] targets = FSDirWriteFileOp.chooseTargetForNewBlock((BlockManager)ns.getBlockManager(), (String)"/testRetryAddBlockWhileInChooseTarget", null, null, null, (FSDirWriteFileOp.ValidateAddBlockResult)r);
        Assert.assertNotNull((String)"Targets must be generated", (Object)targets);
        LOG.info("Starting second addBlock for /testRetryAddBlockWhileInChooseTarget");
        nn.addBlock("/testRetryAddBlockWhileInChooseTarget", "clientName", null, null, 0L, null, null);
        Assert.assertTrue((String)"Penultimate block must be complete", (boolean)this.checkFileProgress("/testRetryAddBlockWhileInChooseTarget", false));
        LocatedBlocks lbs = nn.getBlockLocations("/testRetryAddBlockWhileInChooseTarget", 0L, Long.MAX_VALUE);
        Assert.assertEquals((String)"Must be one block", (long)1L, (long)lbs.getLocatedBlocks().size());
        LocatedBlock lb2 = lbs.get(0);
        Assert.assertEquals((String)"Wrong replication", (long)3L, (long)lb2.getLocations().length);
        ns.writeLock();
        try {
            newBlock = FSDirWriteFileOp.storeAllocatedBlock((FSNamesystem)ns, (String)"/testRetryAddBlockWhileInChooseTarget", (long)0L, (String)"clientName", null, (DatanodeStorageInfo[])targets);
        }
        finally {
            ns.writeUnlock();
        }
        Assert.assertEquals((String)"Blocks are not equal", (Object)lb2.getBlock(), (Object)newBlock.getBlock());
        lbs = nn.getBlockLocations("/testRetryAddBlockWhileInChooseTarget", 0L, Long.MAX_VALUE);
        Assert.assertEquals((String)"Must be one block", (long)1L, (long)lbs.getLocatedBlocks().size());
        LocatedBlock lb1 = lbs.get(0);
        Assert.assertEquals((String)"Wrong replication", (long)3L, (long)lb1.getLocations().length);
        Assert.assertEquals((String)"Blocks are not equal", (Object)lb1.getBlock(), (Object)lb2.getBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFileProgress(String src, boolean checkall) throws IOException {
        FSNamesystem ns = this.cluster.getNamesystem();
        ns.readLock();
        try {
            boolean bl = ns.checkFileProgress(src, ns.dir.getINode(src).asFile(), checkall);
            return bl;
        }
        finally {
            ns.readUnlock();
        }
    }

    @Test
    public void testAddBlockRetryShouldReturnBlockWithLocations() throws Exception {
        String src = "/testAddBlockRetryShouldReturnBlockWithLocations";
        NamenodeProtocols nameNodeRpc = this.cluster.getNameNodeRpc();
        nameNodeRpc.create("/testAddBlockRetryShouldReturnBlockWithLocations", FsPermission.getFileDefault(), "clientName", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)3, 1024L, null, null, null);
        LOG.info("Starting first addBlock for /testAddBlockRetryShouldReturnBlockWithLocations");
        LocatedBlock lb1 = nameNodeRpc.addBlock("/testAddBlockRetryShouldReturnBlockWithLocations", "clientName", null, null, 0L, null, null);
        Assert.assertTrue((String)"Block locations should be present", (lb1.getLocations().length > 0 ? 1 : 0) != 0);
        this.cluster.restartNameNode(new String[0]);
        nameNodeRpc = this.cluster.getNameNodeRpc();
        LocatedBlock lb2 = nameNodeRpc.addBlock("/testAddBlockRetryShouldReturnBlockWithLocations", "clientName", null, null, 0L, null, null);
        Assert.assertEquals((String)"Blocks are not equal", (Object)lb1.getBlock(), (Object)lb2.getBlock());
        Assert.assertTrue((String)"Wrong locations with retry", (lb2.getLocations().length > 0 ? 1 : 0) != 0);
    }
}

