/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestListSnapshot {
    static final short REPLICATION = 3;
    private final Path dir1 = new Path("/TestSnapshot1");
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.namenode.snapshot.deletion.ordered", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.mkdirs(this.dir1);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testListSnapshot() throws Exception {
        this.fsn.getSnapshotManager().setAllowNestedSnapshots(true);
        SnapshotStatus[] snapshotStatuses = null;
        SnapshottableDirectoryStatus[] dirs = this.hdfs.getSnapshottableDirListing();
        Assert.assertNull((Object)dirs);
        LambdaTestUtils.intercept(SnapshotException.class, (String)"Directory is not a snapshottable directory", () -> this.hdfs.getSnapshotListing(this.dir1));
        Path root = new Path("/");
        this.hdfs.allowSnapshot(root);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assert.assertEquals((long)1L, (long)dirs.length);
        Assert.assertEquals((Object)"", (Object)dirs[0].getDirStatus().getLocalName());
        Assert.assertEquals((Object)root, (Object)dirs[0].getFullPath());
        snapshotStatuses = this.hdfs.getSnapshotListing(root);
        Assert.assertTrue((snapshotStatuses.length == 0 ? 1 : 0) != 0);
        this.hdfs.disallowSnapshot(root);
        dirs = this.hdfs.getSnapshottableDirListing();
        Assert.assertNull((Object)dirs);
        snapshotStatuses = this.hdfs.getSnapshotListing(root);
        Assert.assertTrue((snapshotStatuses.length == 0 ? 1 : 0) != 0);
        this.hdfs.allowSnapshot(this.dir1);
        this.hdfs.createSnapshot(this.dir1, "s0");
        snapshotStatuses = this.hdfs.getSnapshotListing(this.dir1);
        Assert.assertEquals((long)1L, (long)snapshotStatuses.length);
        Assert.assertEquals((Object)"s0", (Object)snapshotStatuses[0].getDirStatus().getLocalName());
        Assert.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot(this.dir1, "s0"), (Object)snapshotStatuses[0].getFullPath());
        Assert.assertEquals((long)0L, (long)snapshotStatuses[0].getSnapshotID());
        this.hdfs.createSnapshot(this.dir1, "s1");
        this.hdfs.createSnapshot(this.dir1, "s2");
        snapshotStatuses = this.hdfs.getSnapshotListing(this.dir1);
        Assert.assertEquals((long)3L, (long)snapshotStatuses.length);
        Assert.assertEquals((Object)"s0", (Object)snapshotStatuses[0].getDirStatus().getLocalName());
        Assert.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot(this.dir1, "s0"), (Object)snapshotStatuses[0].getFullPath());
        Assert.assertEquals((Object)"s1", (Object)snapshotStatuses[1].getDirStatus().getLocalName());
        Assert.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot(this.dir1, "s1"), (Object)snapshotStatuses[1].getFullPath());
        Assert.assertEquals((Object)"s2", (Object)snapshotStatuses[2].getDirStatus().getLocalName());
        Assert.assertEquals((Object)SnapshotTestHelper.getSnapshotRoot(this.dir1, "s2"), (Object)snapshotStatuses[2].getFullPath());
        this.hdfs.deleteSnapshot(this.dir1, "s2");
        snapshotStatuses = this.hdfs.getSnapshotListing(this.dir1);
        Assert.assertEquals((long)3L, (long)snapshotStatuses.length);
        Assert.assertTrue((boolean)snapshotStatuses[2].isDeleted());
        Assert.assertFalse((boolean)snapshotStatuses[1].isDeleted());
        Assert.assertFalse((boolean)snapshotStatuses[0].isDeleted());
        this.hdfs.deleteSnapshot(this.dir1, "s0");
        snapshotStatuses = this.hdfs.getSnapshotListing(this.dir1);
        Assert.assertEquals((long)2L, (long)snapshotStatuses.length);
    }
}

