/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.sps;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockStorageMovementAttemptedItems;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockStorageMovementNeeded;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.ItemInfo;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSContext;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlockStorageMovementAttemptedItems {
    private BlockStorageMovementAttemptedItems bsmAttemptedItems;
    private BlockStorageMovementNeeded unsatisfiedStorageMovementFiles;
    private final int selfRetryTimeout = 500;

    @Before
    public void setup() throws Exception {
        HdfsConfiguration config = new HdfsConfiguration();
        Context ctxt = (Context)Mockito.mock(ExternalSPSContext.class);
        StoragePolicySatisfier sps = new StoragePolicySatisfier((Configuration)config);
        Mockito.when((Object)ctxt.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)ctxt.isInSafeMode()).thenReturn((Object)false);
        Mockito.when((Object)ctxt.isFileExist(Mockito.anyLong())).thenReturn((Object)true);
        this.unsatisfiedStorageMovementFiles = new BlockStorageMovementNeeded(ctxt);
        this.bsmAttemptedItems = new BlockStorageMovementAttemptedItems((SPSService)sps, this.unsatisfiedStorageMovementFiles, ctxt);
    }

    @After
    public void teardown() {
        if (this.bsmAttemptedItems != null) {
            this.bsmAttemptedItems.stop();
            this.bsmAttemptedItems.stopGracefully();
        }
    }

    private boolean checkItemMovedForRetry(Long item, long retryTimeout) throws InterruptedException {
        long stopTime = Time.monotonicNow() + retryTimeout * 2L;
        boolean isItemFound = false;
        while (Time.monotonicNow() < stopTime) {
            ItemInfo ele = null;
            while ((ele = this.unsatisfiedStorageMovementFiles.get()) != null) {
                if (item.longValue() != ele.getFile()) continue;
                isItemFound = true;
                break;
            }
            if (isItemFound) break;
            Thread.sleep(100L);
        }
        return isItemFound;
    }

    @Test(timeout=30000L)
    public void testAddReportedMoveAttemptFinishedBlocks() throws Exception {
        Long item = new Long(1234L);
        Block block = new Block(item.longValue());
        DatanodeInfo dnInfo = DFSTestUtil.getLocalDatanodeInfo(9867);
        HashSet<StoragePolicySatisfier.StorageTypeNodePair> locs = new HashSet<StoragePolicySatisfier.StorageTypeNodePair>();
        locs.add(new StoragePolicySatisfier.StorageTypeNodePair(StorageType.ARCHIVE, dnInfo));
        HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>> blocksMap = new HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>>();
        blocksMap.put(block, locs);
        this.bsmAttemptedItems.add(0L, 0L, 0L, blocksMap, 0);
        this.bsmAttemptedItems.notifyReportedBlock(dnInfo, StorageType.ARCHIVE, block);
        Assert.assertEquals((String)"Failed to receive result!", (long)1L, (long)this.bsmAttemptedItems.getMovementFinishedBlocksCount());
    }

    @Test(timeout=30000L)
    public void testNoBlockMovementAttemptFinishedReportAdded() throws Exception {
        Long item = new Long(1234L);
        Block block = new Block(item.longValue());
        DatanodeInfo dnInfo = DFSTestUtil.getLocalDatanodeInfo(9867);
        HashSet<StoragePolicySatisfier.StorageTypeNodePair> locs = new HashSet<StoragePolicySatisfier.StorageTypeNodePair>();
        locs.add(new StoragePolicySatisfier.StorageTypeNodePair(StorageType.ARCHIVE, dnInfo));
        HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>> blocksMap = new HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>>();
        blocksMap.put(block, locs);
        this.bsmAttemptedItems.add(0L, 0L, 0L, blocksMap, 0);
        Assert.assertEquals((String)"Shouldn't receive result", (long)0L, (long)this.bsmAttemptedItems.getMovementFinishedBlocksCount());
        Assert.assertEquals((String)"Item doesn't exist in the attempted list", (long)1L, (long)this.bsmAttemptedItems.getAttemptedItemsCount());
    }

    @Test(timeout=30000L)
    public void testPartialBlockMovementShouldBeRetried1() throws Exception {
        Long item = new Long(1234L);
        Block block1 = new Block(item.longValue());
        Block block2 = new Block(5678L);
        Long trackID = 0L;
        DatanodeInfo dnInfo = DFSTestUtil.getLocalDatanodeInfo(9867);
        HashSet<StoragePolicySatisfier.StorageTypeNodePair> locs = new HashSet<StoragePolicySatisfier.StorageTypeNodePair>();
        locs.add(new StoragePolicySatisfier.StorageTypeNodePair(StorageType.ARCHIVE, dnInfo));
        HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>> blocksMap = new HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>>();
        blocksMap.put(block1, locs);
        blocksMap.put(block2, locs);
        this.bsmAttemptedItems.add(trackID.longValue(), trackID.longValue(), 0L, blocksMap, 0);
        this.bsmAttemptedItems.notifyReportedBlock(dnInfo, StorageType.ARCHIVE, block1);
        this.bsmAttemptedItems.start();
        Assert.assertTrue((String)"Failed to add to the retry list", (boolean)this.checkItemMovedForRetry(trackID, 5000L));
        Assert.assertEquals((String)"Failed to remove from the attempted list", (long)0L, (long)this.bsmAttemptedItems.getAttemptedItemsCount());
    }

    @Test(timeout=30000L)
    public void testPartialBlockMovementShouldBeRetried2() throws Exception {
        Long item = new Long(1234L);
        Block block = new Block(item.longValue());
        Long trackID = 0L;
        DatanodeInfo dnInfo = DFSTestUtil.getLocalDatanodeInfo(9867);
        HashSet<StoragePolicySatisfier.StorageTypeNodePair> locs = new HashSet<StoragePolicySatisfier.StorageTypeNodePair>();
        locs.add(new StoragePolicySatisfier.StorageTypeNodePair(StorageType.ARCHIVE, dnInfo));
        HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>> blocksMap = new HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>>();
        blocksMap.put(block, locs);
        this.bsmAttemptedItems.add(trackID.longValue(), trackID.longValue(), 0L, blocksMap, 0);
        this.bsmAttemptedItems.notifyReportedBlock(dnInfo, StorageType.ARCHIVE, block);
        Thread.sleep(1000L);
        this.bsmAttemptedItems.blocksStorageMovementUnReportedItemsCheck();
        this.bsmAttemptedItems.blockStorageMovementReportedItemsCheck();
        Assert.assertTrue((String)"Failed to add to the retry list", (boolean)this.checkItemMovedForRetry(trackID, 5000L));
        Assert.assertEquals((String)"Failed to remove from the attempted list", (long)0L, (long)this.bsmAttemptedItems.getAttemptedItemsCount());
    }

    @Test(timeout=30000L)
    public void testPartialBlockMovementWithEmptyAttemptedQueue() throws Exception {
        Long item = new Long(1234L);
        Block block = new Block(item.longValue());
        Long trackID = 0L;
        DatanodeInfo dnInfo = DFSTestUtil.getLocalDatanodeInfo(9867);
        HashSet<StoragePolicySatisfier.StorageTypeNodePair> locs = new HashSet<StoragePolicySatisfier.StorageTypeNodePair>();
        locs.add(new StoragePolicySatisfier.StorageTypeNodePair(StorageType.ARCHIVE, dnInfo));
        HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>> blocksMap = new HashMap<Block, HashSet<StoragePolicySatisfier.StorageTypeNodePair>>();
        blocksMap.put(block, locs);
        this.bsmAttemptedItems.add(trackID.longValue(), trackID.longValue(), 0L, blocksMap, 0);
        this.bsmAttemptedItems.notifyReportedBlock(dnInfo, StorageType.ARCHIVE, block);
        Assert.assertFalse((String)"Should not add in queue again if it is not there in storageMovementAttemptedItems", (boolean)this.checkItemMovedForRetry(trackID, 5000L));
        Assert.assertEquals((String)"Failed to remove from the attempted list", (long)1L, (long)this.bsmAttemptedItems.getAttemptedItemsCount());
    }
}

