/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.nodelabels;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeDescriptorsProvider;

public abstract class AbstractNodeDescriptorsProvider<T>
extends AbstractService
implements NodeDescriptorsProvider<T> {
    public static final long DISABLE_NODE_DESCRIPTORS_PROVIDER_FETCH_TIMER = -1L;
    private long intervalTime = -1L;
    private Timer scheduler;
    protected Lock readLock = null;
    protected Lock writeLock = null;
    protected TimerTask timerTask;
    private Set<T> nodeDescriptors = Collections.unmodifiableSet(new HashSet(0));

    public AbstractNodeDescriptorsProvider(String name) {
        super(name);
    }

    public long getIntervalTime() {
        return this.intervalTime;
    }

    public void setIntervalTime(long intervalMS) {
        this.intervalTime = intervalMS;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.timerTask = this.createTimerTask();
        this.timerTask.run();
        long taskInterval = this.getIntervalTime();
        if (taskInterval != -1L) {
            this.scheduler = new Timer("DistributedNodeDescriptorsRunner-Timer", true);
            this.scheduler.schedule(this.timerTask, taskInterval, taskInterval);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.cancel();
        }
        this.cleanUp();
        super.serviceStop();
    }

    protected abstract void cleanUp() throws Exception;

    @Override
    public Set<T> getDescriptors() {
        this.readLock.lock();
        try {
            Set<T> set = this.nodeDescriptors;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setDescriptors(Set<T> descriptorsSet) {
        this.writeLock.lock();
        try {
            this.nodeDescriptors = descriptorsSet;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void verifyConfiguredScript(String scriptPath) throws IOException {
        boolean invalidConfiguration;
        if (scriptPath == null || scriptPath.trim().isEmpty()) {
            invalidConfiguration = true;
        } else {
            File f = new File(scriptPath);
            boolean bl = invalidConfiguration = !f.exists() || !FileUtil.canExecute((File)f);
        }
        if (invalidConfiguration) {
            throw new IOException("Node descriptors provider script \"" + scriptPath + "\" is not configured properly. Please check whether the script path exists, owner and the access rights are suitable for NM process to execute it");
        }
    }

    static Set<NodeLabel> convertToNodeLabelSet(String partitionNodeLabel) {
        if (null == partitionNodeLabel) {
            return null;
        }
        HashSet<NodeLabel> labels = new HashSet<NodeLabel>();
        labels.add(NodeLabel.newInstance((String)partitionNodeLabel));
        return labels;
    }

    TimerTask getTimerTask() {
        return this.timerTask;
    }

    @VisibleForTesting
    public Timer getScheduler() {
        return this.scheduler;
    }

    public abstract TimerTask createTimerTask();
}

