/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestBulkloadBase {
    @ClassRule
    public static TemporaryFolder testFolder = new TemporaryFolder();
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected final WAL log = (WAL)Mockito.mock(WAL.class);
    protected final Configuration conf = HBaseConfiguration.create();
    private final byte[] randomBytes = new byte[100];
    protected final byte[] family1 = Bytes.toBytes((String)"family1");
    protected final byte[] family2 = Bytes.toBytes((String)"family2");
    protected final byte[] family3 = Bytes.toBytes((String)"family3");
    protected Boolean useFileBasedSFT;
    @Rule
    public TestName name = new TestName();

    public TestBulkloadBase(boolean useFileBasedSFT) {
        this.useFileBasedSFT = useFileBasedSFT;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> data() {
        Boolean[] data = new Boolean[]{false, true};
        return Arrays.asList(data);
    }

    @Before
    public void before() throws IOException {
        Bytes.random((byte[])this.randomBytes);
        if (this.useFileBasedSFT.booleanValue()) {
            this.conf.set("hbase.store.file-tracker.impl", "org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker");
        } else {
            this.conf.unset("hbase.store.file-tracker.impl");
        }
    }

    protected Pair<byte[], String> withMissingHFileForFamily(byte[] family) {
        return new Pair((Object)family, (Object)this.getNotExistFilePath());
    }

    private String getNotExistFilePath() {
        Path path = new Path(TEST_UTIL.getDataTestDir(), "does_not_exist");
        return path.toUri().getPath();
    }

    protected Pair<byte[], String> withInvalidColumnFamilyButProperHFileLocation(byte[] family) throws IOException {
        this.createHFileForFamilies(family);
        return new Pair((Object)new byte[]{0, 1, 2}, (Object)this.getNotExistFilePath());
    }

    protected HRegion testRegionWithFamiliesAndSpecifiedTableName(TableName tableName, byte[] ... families) throws IOException {
        RegionInfo hRegionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return HRegion.createHRegion((RegionInfo)hRegionInfo, (Path)new Path(testFolder.newFolder().toURI()), (Configuration)this.conf, (TableDescriptor)builder.build(), (WAL)this.log);
    }

    protected HRegion testRegionWithFamilies(byte[] ... families) throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName().substring(0, this.name.getMethodName().indexOf("[")));
        return this.testRegionWithFamiliesAndSpecifiedTableName(tableName, families);
    }

    private List<Pair<byte[], String>> getBlankFamilyPaths() {
        return new ArrayList<Pair<byte[], String>>();
    }

    protected List<Pair<byte[], String>> withFamilyPathsFor(byte[] ... families) throws IOException {
        List<Pair<byte[], String>> familyPaths = this.getBlankFamilyPaths();
        for (byte[] family : families) {
            familyPaths.add((Pair<byte[], String>)new Pair((Object)family, (Object)this.createHFileForFamilies(family)));
        }
        return familyPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHFileForFamilies(byte[] family) throws IOException {
        HFile.WriterFactory hFileFactory = HFile.getWriterFactoryNoCache((Configuration)this.conf);
        File hFileLocation = testFolder.newFile(TestBulkloadBase.generateUniqueName(null));
        try (FSDataOutputStream out = new FSDataOutputStream((OutputStream)new FileOutputStream(hFileLocation), null);){
            hFileFactory.withOutputStream(out);
            hFileFactory.withFileContext(new HFileContextBuilder().build());
            try (HFile.Writer writer = hFileFactory.create();){
                writer.append((Cell)new KeyValue((Cell)ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(this.randomBytes).setFamily(family).setQualifier(this.randomBytes).setTimestamp(0L).setType(KeyValue.Type.Put.getCode()).setValue(this.randomBytes).build()));
            }
        }
        return hFileLocation.getAbsoluteFile().getAbsolutePath();
    }

    private static String generateUniqueName(String suffix) {
        String name = UUID.randomUUID().toString().replaceAll("-", "");
        if (suffix != null) {
            name = name + suffix;
        }
        return name;
    }

    protected static Matcher<WALEdit> bulkLogWalEditType(byte[] typeBytes) {
        return new WalMatcher(typeBytes);
    }

    protected static Matcher<WALEdit> bulkLogWalEdit(byte[] typeBytes, byte[] tableName, byte[] familyName, List<String> storeFileNames) {
        return new WalMatcher(typeBytes, tableName, familyName, storeFileNames);
    }

    private static class WalMatcher
    extends TypeSafeMatcher<WALEdit> {
        private final byte[] typeBytes;
        private final byte[] tableName;
        private final byte[] familyName;
        private final List<String> storeFileNames;

        public WalMatcher(byte[] typeBytes) {
            this(typeBytes, null, null, null);
        }

        public WalMatcher(byte[] typeBytes, byte[] tableName, byte[] familyName, List<String> storeFileNames) {
            this.typeBytes = typeBytes;
            this.tableName = tableName;
            this.familyName = familyName;
            this.storeFileNames = storeFileNames;
        }

        protected boolean matchesSafely(WALEdit item) {
            WALProtos.BulkLoadDescriptor desc;
            Assert.assertTrue((boolean)Arrays.equals(CellUtil.cloneQualifier((Cell)((Cell)item.getCells().get(0))), this.typeBytes));
            try {
                desc = WALEdit.getBulkLoadDescriptor((Cell)((Cell)item.getCells().get(0)));
            }
            catch (IOException e) {
                return false;
            }
            Assert.assertNotNull((Object)desc);
            if (this.tableName != null) {
                Assert.assertTrue((boolean)Bytes.equals((byte[])ProtobufUtil.toTableName((HBaseProtos.TableName)desc.getTableName()).getName(), (byte[])this.tableName));
            }
            if (this.storeFileNames != null) {
                boolean index = false;
                WALProtos.StoreDescriptor store = desc.getStores(0);
                Assert.assertTrue((boolean)Bytes.equals((byte[])store.getFamilyName().toByteArray(), (byte[])this.familyName));
                Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)store.getStoreHomeDir()), (byte[])this.familyName));
                Assert.assertEquals((long)this.storeFileNames.size(), (long)store.getStoreFileCount());
            }
            return true;
        }

        public void describeTo(Description description) {
        }
    }
}

