/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.mockito.Mockito;

public abstract class WALEntryStreamTestBase {
    protected static final long TEST_TIMEOUT_MS = 5000L;
    protected static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static Configuration CONF;
    protected static FileSystem fs;
    protected static MiniDFSCluster cluster;
    protected static final TableName tableName;
    protected static final byte[] family;
    protected static final byte[] qualifier;
    protected static final RegionInfo info;
    protected static final NavigableMap<byte[], Integer> scopes;
    protected final String fakeWalGroupId = "fake-wal-group-id";
    protected WAL log;
    protected ReplicationSourceLogQueue logQueue;
    protected PathWatcher pathWatcher;
    @Rule
    public TestName tn = new TestName();
    protected final MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();

    private static NavigableMap<byte[], Integer> getScopes() {
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        scopes.put(family, 1);
        return scopes;
    }

    protected static void startCluster() throws Exception {
        CONF = TEST_UTIL.getConfiguration();
        CONF.setLong("replication.source.sleepforretries", 10L);
        TEST_UTIL.startMiniDFSCluster(3);
        cluster = TEST_UTIL.getDFSCluster();
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    protected void initWAL() throws IOException {
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        MetricsSource metricsSource = new MetricsSource("2");
        metricsSource.clear();
        this.logQueue = new ReplicationSourceLogQueue(CONF, metricsSource, source);
        this.pathWatcher = new PathWatcher();
        WALFactory wals = new WALFactory(CONF, TableNameTestRule.cleanUpTestName((String)this.tn.getMethodName()));
        wals.getWALProvider().addWALActionsListener((WALActionsListener)this.pathWatcher);
        this.log = wals.getWAL(info);
    }

    @After
    public void tearDown() throws Exception {
        Closeables.close((Closeable)this.log, (boolean)true);
    }

    protected void appendToLogAndSync() throws IOException {
        this.appendToLogAndSync(1);
    }

    protected void appendToLogAndSync(int count) throws IOException {
        long txid = this.appendToLog(count);
        this.log.sync(txid);
    }

    protected long appendToLog(int count) throws IOException {
        return this.log.appendData(info, new WALKeyImpl(info.getEncodedNameAsBytes(), tableName, EnvironmentEdgeManager.currentTime(), this.mvcc, scopes), this.getWALEdits(count));
    }

    protected WALEdit getWALEdits(int count) {
        WALEdit edit = new WALEdit();
        for (int i = 0; i < count; ++i) {
            edit.add((Cell)new KeyValue(Bytes.toBytes((long)EnvironmentEdgeManager.currentTime()), family, qualifier, EnvironmentEdgeManager.currentTime(), qualifier));
        }
        return edit;
    }

    static {
        tableName = TableName.valueOf((String)"tablename");
        family = Bytes.toBytes((String)"column");
        qualifier = Bytes.toBytes((String)"qualifier");
        info = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.LAST_ROW).build();
        scopes = WALEntryStreamTestBase.getScopes();
    }

    class PathWatcher
    implements WALActionsListener {
        Path currentPath;

        PathWatcher() {
        }

        public void preLogRoll(Path oldPath, Path newPath) {
            WALEntryStreamTestBase.this.logQueue.enqueueLog(newPath, "fake-wal-group-id");
            this.currentPath = newPath;
        }
    }

    protected static class WALEntryStreamWithRetries
    extends WALEntryStream {
        private WAL.Entry result;

        public WALEntryStreamWithRetries(ReplicationSourceLogQueue logQueue, Configuration conf, long startPosition, WALFileLengthProvider walFileLengthProvider, ServerName serverName, MetricsSource metrics, String walGroupId) throws IOException {
            super(logQueue, conf, startPosition, walFileLengthProvider, serverName, metrics, walGroupId);
        }

        public WAL.Entry next() {
            Waiter.waitFor((Configuration)CONF, (long)5000L, () -> {
                this.result = WALEntryStreamWithRetries.super.next();
                return this.result != null;
            });
            return this.result;
        }
    }
}

