/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.LocalityBasedCostFunction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RackLocalityCostFunction
extends LocalityBasedCostFunction {
    private static final String RACK_LOCALITY_COST_KEY = "hbase.master.balancer.stochastic.rackLocalityCost";
    private static final float DEFAULT_RACK_LOCALITY_COST = 15.0f;

    public RackLocalityCostFunction(Configuration conf) {
        super(conf, BalancerClusterState.LocalityType.RACK, RACK_LOCALITY_COST_KEY, 15.0f);
    }

    @Override
    int regionIndexToEntityIndex(int region) {
        return this.cluster.getRackForRegion(region);
    }
}

