/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface Store {
    public static final int PRIORITY_USER = 1;
    public static final int NO_PRIORITY = Integer.MIN_VALUE;

    public CellComparator getComparator();

    public Collection<? extends StoreFile> getStorefiles();

    public Collection<? extends StoreFile> getCompactedFiles();

    public long timeOfOldestEdit();

    public FileSystem getFileSystem();

    public boolean shouldPerformMajorCompaction() throws IOException;

    public boolean needsCompaction();

    public int getCompactPriority();

    public boolean canSplit();

    public boolean hasReferences();

    public MemStoreSize getMemStoreSize();

    public MemStoreSize getFlushableSize();

    public MemStoreSize getSnapshotSize();

    public ColumnFamilyDescriptor getColumnFamilyDescriptor();

    public OptionalLong getMaxSequenceId();

    public OptionalLong getMaxMemStoreTS();

    public long getLastCompactSize();

    public long getSize();

    public int getStorefilesCount();

    public int getCompactedFilesCount();

    public OptionalLong getMaxStoreFileAge();

    public OptionalLong getMinStoreFileAge();

    public OptionalDouble getAvgStoreFileAge();

    public long getNumReferenceFiles();

    public long getNumHFiles();

    public long getStoreSizeUncompressed();

    public long getStorefilesSize();

    public long getHFilesSize();

    public long getStorefilesRootLevelIndexSize();

    public long getTotalStaticIndexSize();

    public long getTotalStaticBloomSize();

    public RegionInfo getRegionInfo();

    public boolean areWritesEnabled();

    public long getSmallestReadPoint();

    public String getColumnFamilyName();

    public TableName getTableName();

    public long getFlushedCellsCount();

    public long getFlushedCellsSize();

    public long getFlushedOutputFileSize();

    public long getCompactedCellsCount();

    public long getCompactedCellsSize();

    public long getMajorCompactedCellsCount();

    public long getMajorCompactedCellsSize();

    public boolean hasTooManyStoreFiles();

    public void refreshStoreFiles() throws IOException;

    public double getCompactionPressure();

    public boolean isPrimaryReplicaStore();

    public boolean isSloppyMemStore();

    public int getCurrentParallelPutCount();

    public long getMemstoreOnlyRowReadsCount();

    public long getMixedRowReadsCount();

    public Configuration getReadOnlyConfiguration();

    public long getBloomFilterRequestsCount();

    public long getBloomFilterNegativeResultsCount();

    public long getBloomFilterEligibleRequestsCount();
}

