/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.io.netty.util.ResourceLeakDetector;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogLevel;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.Slf4JLoggerFactory;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, SmallTests.class})
public class TestByteBuffAllocatorLeakDetection {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBuffAllocatorLeakDetection.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeakDetection() throws InterruptedException {
        InternalLoggerFactory original = InternalLoggerFactory.getDefaultFactory();
        AtomicInteger leaksDetected = new AtomicInteger();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new MockedLoggerFactory(leaksDetected));
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
        Assert.assertTrue((boolean)ResourceLeakDetector.isEnabled());
        try {
            int maxBuffersInPool = 10;
            int bufSize = 1024;
            int minSize = bufSize / 8;
            ByteBuffAllocator alloc = new ByteBuffAllocator(true, maxBuffersInPool, bufSize, minSize);
            alloc.allocate(minSize - 1);
            System.gc();
            Thread.sleep(1000L);
            ByteBuff reference = alloc.allocate(minSize * 2);
            Assert.assertEquals((long)0L, (long)leaksDetected.get());
            alloc.allocate(minSize * 2);
            System.gc();
            Thread.sleep(1000L);
            alloc.allocate(minSize * 2);
            Assert.assertEquals((long)1L, (long)leaksDetected.get());
        }
        finally {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)original);
        }
    }

    private static class MockedLogger
    implements InternalLogger {
        private AtomicInteger leaksDetected;
        private InternalLogger delegate;

        public MockedLogger(AtomicInteger leaksDetected, InternalLogger delegate) {
            this.leaksDetected = leaksDetected;
            this.delegate = delegate;
        }

        private void maybeCountLeak(String msgOrFormat) {
            if (msgOrFormat.startsWith("LEAK")) {
                this.leaksDetected.incrementAndGet();
            }
        }

        public void error(String msg) {
            this.maybeCountLeak(msg);
            this.delegate.error(msg);
        }

        public void error(String format, Object arg) {
            this.maybeCountLeak(format);
            this.delegate.error(format, arg);
        }

        public void error(String format, Object argA, Object argB) {
            this.maybeCountLeak(format);
            this.delegate.error(format, argA, argB);
        }

        public void error(String format, Object ... arguments) {
            this.maybeCountLeak(format);
            this.delegate.error(format, arguments);
        }

        public void error(String msg, Throwable t) {
            this.maybeCountLeak(msg);
            this.delegate.error(msg, t);
        }

        public void error(Throwable t) {
            this.delegate.error(t);
        }

        public String name() {
            return this.delegate.name();
        }

        public boolean isTraceEnabled() {
            return this.delegate.isTraceEnabled();
        }

        public void trace(String msg) {
            this.delegate.trace(msg);
        }

        public void trace(String format, Object arg) {
            this.delegate.trace(format, arg);
        }

        public void trace(String format, Object argA, Object argB) {
            this.delegate.trace(format, argA, argB);
        }

        public void trace(String format, Object ... arguments) {
            this.delegate.trace(format, arguments);
        }

        public void trace(String msg, Throwable t) {
            this.delegate.trace(msg, t);
        }

        public void trace(Throwable t) {
            this.delegate.trace(t);
        }

        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }

        public void debug(String msg) {
            this.delegate.debug(msg);
        }

        public void debug(String format, Object arg) {
            this.delegate.debug(format, arg);
        }

        public void debug(String format, Object argA, Object argB) {
            this.delegate.debug(format, argA, argB);
        }

        public void debug(String format, Object ... arguments) {
            this.delegate.debug(format, arguments);
        }

        public void debug(String msg, Throwable t) {
            this.delegate.debug(msg, t);
        }

        public void debug(Throwable t) {
            this.delegate.debug(t);
        }

        public boolean isInfoEnabled() {
            return this.delegate.isInfoEnabled();
        }

        public void info(String msg) {
            this.delegate.info(msg);
        }

        public void info(String format, Object arg) {
            this.delegate.info(format, arg);
        }

        public void info(String format, Object argA, Object argB) {
            this.delegate.info(format, argA, argB);
        }

        public void info(String format, Object ... arguments) {
            this.delegate.info(format, arguments);
        }

        public void info(String msg, Throwable t) {
            this.delegate.info(msg, t);
        }

        public void info(Throwable t) {
            this.delegate.info(t);
        }

        public boolean isWarnEnabled() {
            return this.delegate.isWarnEnabled();
        }

        public void warn(String msg) {
            this.delegate.warn(msg);
        }

        public void warn(String format, Object arg) {
            this.delegate.warn(format, arg);
        }

        public void warn(String format, Object ... arguments) {
            this.delegate.warn(format, arguments);
        }

        public void warn(String format, Object argA, Object argB) {
            this.delegate.warn(format, argA, argB);
        }

        public void warn(String msg, Throwable t) {
            this.delegate.warn(msg, t);
        }

        public void warn(Throwable t) {
            this.delegate.warn(t);
        }

        public boolean isErrorEnabled() {
            return this.delegate.isErrorEnabled();
        }

        public boolean isEnabled(InternalLogLevel level) {
            return this.delegate.isEnabled(level);
        }

        public void log(InternalLogLevel level, String msg) {
            this.delegate.log(level, msg);
        }

        public void log(InternalLogLevel level, String format, Object arg) {
            this.delegate.log(level, format, arg);
        }

        public void log(InternalLogLevel level, String format, Object argA, Object argB) {
            this.delegate.log(level, format, argA, argB);
        }

        public void log(InternalLogLevel level, String format, Object ... arguments) {
            this.delegate.log(level, format, arguments);
        }

        public void log(InternalLogLevel level, String msg, Throwable t) {
            this.delegate.log(level, msg, t);
        }

        public void log(InternalLogLevel level, Throwable t) {
            this.delegate.log(level, t);
        }
    }

    private static class MockedLoggerFactory
    extends Slf4JLoggerFactory {
        private AtomicInteger leaksDetected;

        public MockedLoggerFactory(AtomicInteger leaksDetected) {
            this.leaksDetected = leaksDetected;
        }

        public InternalLogger newInstance(String name) {
            InternalLogger delegate = super.newInstance(name);
            return new MockedLogger(this.leaksDetected, delegate);
        }
    }
}

