/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class UniformRandomRouterPolicy
extends AbstractRouterPolicy {
    private Random rand = new Random(System.currentTimeMillis());

    @Override
    public void reinitialize(FederationPolicyInitializationContext policyContext) throws FederationPolicyInitializationException {
        FederationPolicyInitializationContextValidator.validate(policyContext, this.getClass().getCanonicalName());
        this.setPolicyContext(policyContext);
    }

    @Override
    protected SubClusterId chooseSubCluster(String queue, Map<SubClusterId, SubClusterInfo> preSelectSubclusters) throws YarnException {
        if (preSelectSubclusters == null || preSelectSubclusters.isEmpty()) {
            throw new FederationPolicyException("No available subcluster to choose from.");
        }
        ArrayList<SubClusterId> list = new ArrayList<SubClusterId>(preSelectSubclusters.keySet());
        return (SubClusterId)list.get(this.rand.nextInt(list.size()));
    }
}

