/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security;

import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.LocalizerTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizerTokenSelector
implements TokenSelector<LocalizerTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalizerTokenSelector.class);

    public Token<LocalizerTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        LOG.debug("Using localizerTokenSelector.");
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug("Token of kind {} is found", (Object)token.getKind());
            if (!LocalizerTokenIdentifier.KIND.equals((Object)token.getKind())) continue;
            return token;
        }
        LOG.debug("Returning null.");
        return null;
    }
}

