/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.recovery;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ResourceMappings;
import org.apache.hadoop.yarn.server.nodemanager.recovery.RecoveryIterator;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class NMStateStoreService
extends AbstractService {
    private NodeStatusUpdater nodeStatusUpdater = null;

    public NMStateStoreService(String name) {
        super(name);
    }

    protected NodeStatusUpdater getNodeStatusUpdater() {
        return this.nodeStatusUpdater;
    }

    public void setNodeStatusUpdater(NodeStatusUpdater nodeStatusUpdater) {
        this.nodeStatusUpdater = nodeStatusUpdater;
    }

    public void serviceInit(Configuration conf) throws IOException {
        this.initStorage(conf);
    }

    public void serviceStart() throws IOException {
        this.startStorage();
    }

    public void serviceStop() throws IOException {
        this.closeStorage();
    }

    public boolean canRecover() {
        return true;
    }

    public boolean isNewlyCreated() {
        return false;
    }

    public abstract RecoveredApplicationsState loadApplicationsState() throws IOException;

    public abstract void storeApplication(ApplicationId var1, YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto var2) throws IOException;

    public abstract void removeApplication(ApplicationId var1) throws IOException;

    public abstract RecoveryIterator<RecoveredContainerState> getContainerStateIterator() throws IOException;

    public abstract void storeContainer(ContainerId var1, int var2, long var3, StartContainerRequest var5) throws IOException;

    public abstract void storeContainerQueued(ContainerId var1) throws IOException;

    public abstract void storeContainerPaused(ContainerId var1) throws IOException;

    public abstract void removeContainerPaused(ContainerId var1) throws IOException;

    public abstract void storeContainerLaunched(ContainerId var1) throws IOException;

    public abstract void storeContainerUpdateToken(ContainerId var1, ContainerTokenIdentifier var2) throws IOException;

    public abstract void storeContainerCompleted(ContainerId var1, int var2) throws IOException;

    public abstract void storeContainerKilled(ContainerId var1) throws IOException;

    public abstract void storeContainerDiagnostics(ContainerId var1, StringBuilder var2) throws IOException;

    public abstract void storeContainerRemainingRetryAttempts(ContainerId var1, int var2) throws IOException;

    public abstract void storeContainerRestartTimes(ContainerId var1, List<Long> var2) throws IOException;

    public abstract void storeContainerWorkDir(ContainerId var1, String var2) throws IOException;

    public abstract void storeContainerLogDir(ContainerId var1, String var2) throws IOException;

    public abstract void removeContainer(ContainerId var1) throws IOException;

    public abstract RecoveredLocalizationState loadLocalizationState() throws IOException;

    public abstract void startResourceLocalization(String var1, ApplicationId var2, YarnProtos.LocalResourceProto var3, Path var4) throws IOException;

    public abstract void finishResourceLocalization(String var1, ApplicationId var2, YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto var3) throws IOException;

    public abstract void removeLocalizedResource(String var1, ApplicationId var2, Path var3) throws IOException;

    public abstract RecoveredDeletionServiceState loadDeletionServiceState() throws IOException;

    public abstract void storeDeletionTask(int var1, YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto var2) throws IOException;

    public abstract void removeDeletionTask(int var1) throws IOException;

    public abstract RecoveredNMTokensState loadNMTokensState() throws IOException;

    public abstract void storeNMTokenCurrentMasterKey(MasterKey var1) throws IOException;

    public abstract void storeNMTokenPreviousMasterKey(MasterKey var1) throws IOException;

    public abstract void storeNMTokenApplicationMasterKey(ApplicationAttemptId var1, MasterKey var2) throws IOException;

    public abstract void removeNMTokenApplicationMasterKey(ApplicationAttemptId var1) throws IOException;

    public abstract RecoveredContainerTokensState loadContainerTokensState() throws IOException;

    public abstract void storeContainerTokenCurrentMasterKey(MasterKey var1) throws IOException;

    public abstract void storeContainerTokenPreviousMasterKey(MasterKey var1) throws IOException;

    public abstract void storeContainerToken(ContainerId var1, Long var2) throws IOException;

    public abstract void removeContainerToken(ContainerId var1) throws IOException;

    public abstract RecoveredLogDeleterState loadLogDeleterState() throws IOException;

    public abstract void storeLogDeleter(ApplicationId var1, YarnServerNodemanagerRecoveryProtos.LogDeleterProto var2) throws IOException;

    public abstract void removeLogDeleter(ApplicationId var1) throws IOException;

    public abstract RecoveredAMRMProxyState loadAMRMProxyState() throws IOException;

    public abstract void storeAMRMProxyCurrentMasterKey(MasterKey var1) throws IOException;

    public abstract void storeAMRMProxyNextMasterKey(MasterKey var1) throws IOException;

    public abstract void storeAMRMProxyAppContextEntry(ApplicationAttemptId var1, String var2, byte[] var3) throws IOException;

    public abstract void removeAMRMProxyAppContextEntry(ApplicationAttemptId var1, String var2) throws IOException;

    public abstract void removeAMRMProxyAppContext(ApplicationAttemptId var1) throws IOException;

    public abstract void storeAssignedResources(Container var1, String var2, List<Serializable> var3) throws IOException;

    public void releaseAssignedResources(ContainerId containerId, String resourceType) throws IOException {
    }

    protected abstract void initStorage(Configuration var1) throws IOException;

    protected abstract void startStorage() throws IOException;

    protected abstract void closeStorage() throws IOException;

    protected void updateContainerResourceMapping(Container container, String resourceType, List<Serializable> assignedResources) {
        ResourceMappings.AssignedResources newAssigned = new ResourceMappings.AssignedResources();
        newAssigned.updateAssignedResources(assignedResources);
        container.getResourceMappings().addAssignedResources(resourceType, newAssigned);
    }

    public static class RecoveredAMRMProxyState {
        private MasterKey currentMasterKey;
        private MasterKey nextMasterKey;
        private Map<ApplicationAttemptId, Map<String, byte[]>> appContexts = new HashMap<ApplicationAttemptId, Map<String, byte[]>>();

        public MasterKey getCurrentMasterKey() {
            return this.currentMasterKey;
        }

        public MasterKey getNextMasterKey() {
            return this.nextMasterKey;
        }

        public Map<ApplicationAttemptId, Map<String, byte[]>> getAppContexts() {
            return this.appContexts;
        }

        public void setCurrentMasterKey(MasterKey currentKey) {
            this.currentMasterKey = currentKey;
        }

        public void setNextMasterKey(MasterKey nextKey) {
            this.nextMasterKey = nextKey;
        }
    }

    public static class RecoveredLogDeleterState {
        Map<ApplicationId, YarnServerNodemanagerRecoveryProtos.LogDeleterProto> logDeleterMap;

        public Map<ApplicationId, YarnServerNodemanagerRecoveryProtos.LogDeleterProto> getLogDeleterMap() {
            return this.logDeleterMap;
        }
    }

    public static class RecoveredContainerTokensState {
        MasterKey currentMasterKey;
        MasterKey previousMasterKey;
        RecoveryIterator<Map.Entry<ContainerId, Long>> it = null;

        public RecoveryIterator<Map.Entry<ContainerId, Long>> getIterator() {
            return this.it;
        }

        public MasterKey getCurrentMasterKey() {
            return this.currentMasterKey;
        }

        public MasterKey getPreviousMasterKey() {
            return this.previousMasterKey;
        }
    }

    public static class RecoveredNMTokensState {
        MasterKey currentMasterKey;
        MasterKey previousMasterKey;
        RecoveryIterator<Map.Entry<ApplicationAttemptId, MasterKey>> it = null;

        public RecoveryIterator<Map.Entry<ApplicationAttemptId, MasterKey>> getIterator() {
            return this.it;
        }

        public MasterKey getCurrentMasterKey() {
            return this.currentMasterKey;
        }

        public MasterKey getPreviousMasterKey() {
            return this.previousMasterKey;
        }
    }

    public static class RecoveredDeletionServiceState {
        RecoveryIterator<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto> it = null;

        public RecoveryIterator<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto> getIterator() {
            return this.it;
        }
    }

    public static class RecoveredLocalizationState {
        LocalResourceTrackerState publicTrackerState = new LocalResourceTrackerState(null, null);
        RecoveryIterator<Map.Entry<String, RecoveredUserResources>> it = null;

        public LocalResourceTrackerState getPublicTrackerState() {
            return this.publicTrackerState;
        }

        public RecoveryIterator<Map.Entry<String, RecoveredUserResources>> getIterator() {
            return this.it;
        }
    }

    public static class RecoveredUserResources {
        LocalResourceTrackerState privateTrackerState = new LocalResourceTrackerState(null, null);
        Map<ApplicationId, LocalResourceTrackerState> appTrackerStates = new HashMap<ApplicationId, LocalResourceTrackerState>();

        public LocalResourceTrackerState getPrivateTrackerState() {
            return this.privateTrackerState;
        }

        public Map<ApplicationId, LocalResourceTrackerState> getAppTrackerStates() {
            return this.appTrackerStates;
        }
    }

    public static class LocalResourceTrackerState {
        private final RecoveryIterator<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> completedResourcesIterator;
        private final RecoveryIterator<Map.Entry<YarnProtos.LocalResourceProto, Path>> startedResourcesIterator;

        LocalResourceTrackerState(RecoveryIterator<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> crIt, RecoveryIterator<Map.Entry<YarnProtos.LocalResourceProto, Path>> srIt) {
            this.completedResourcesIterator = crIt;
            this.startedResourcesIterator = srIt;
        }

        public RecoveryIterator<YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto> getCompletedResourcesIterator() {
            return this.completedResourcesIterator;
        }

        public RecoveryIterator<Map.Entry<YarnProtos.LocalResourceProto, Path>> getStartedResourcesIterator() {
            return this.startedResourcesIterator;
        }
    }

    public static class RecoveredContainerState {
        RecoveredContainerStatus status;
        int exitCode = -1000;
        boolean killed = false;
        String diagnostics = "";
        StartContainerRequest startRequest;
        Resource capability;
        private int remainingRetryAttempts = -1000;
        private List<Long> restartTimes;
        private String workDir;
        private String logDir;
        int version;
        private RecoveredContainerType recoveryType = RecoveredContainerType.RECOVER;
        private long startTime;
        private ResourceMappings resMappings = new ResourceMappings();
        private final ContainerId containerId;

        RecoveredContainerState(ContainerId containerId) {
            this.containerId = containerId;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public RecoveredContainerStatus getStatus() {
            return this.status;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public boolean getKilled() {
            return this.killed;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public int getVersion() {
            return this.version;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long ts) {
            this.startTime = ts;
        }

        public StartContainerRequest getStartRequest() {
            return this.startRequest;
        }

        public Resource getCapability() {
            return this.capability;
        }

        public int getRemainingRetryAttempts() {
            return this.remainingRetryAttempts;
        }

        public void setRemainingRetryAttempts(int retryAttempts) {
            this.remainingRetryAttempts = retryAttempts;
        }

        public List<Long> getRestartTimes() {
            return this.restartTimes;
        }

        public void setRestartTimes(List<Long> restartTimes) {
            this.restartTimes = restartTimes;
        }

        public String getWorkDir() {
            return this.workDir;
        }

        public void setWorkDir(String workDir) {
            this.workDir = workDir;
        }

        public String getLogDir() {
            return this.logDir;
        }

        public void setLogDir(String logDir) {
            this.logDir = logDir;
        }

        public String toString() {
            return new StringBuffer("Status: ").append((Object)this.getStatus()).append(", Exit code: ").append(this.exitCode).append(", Version: ").append(this.version).append(", Start Time: ").append(this.startTime).append(", Killed: ").append(this.getKilled()).append(", Diagnostics: ").append(this.getDiagnostics()).append(", Capability: ").append(this.getCapability()).append(", StartRequest: ").append(this.getStartRequest()).append(", RemainingRetryAttempts: ").append(this.remainingRetryAttempts).append(", RestartTimes: ").append(this.restartTimes).append(", WorkDir: ").append(this.workDir).append(", LogDir: ").append(this.logDir).toString();
        }

        public RecoveredContainerType getRecoveryType() {
            return this.recoveryType;
        }

        public void setRecoveryType(RecoveredContainerType recoveryType) {
            this.recoveryType = recoveryType;
        }

        public ResourceMappings getResourceMappings() {
            return this.resMappings;
        }

        public void setResourceMappings(ResourceMappings mappings) {
            this.resMappings = mappings;
        }
    }

    public static enum RecoveredContainerStatus {
        REQUESTED,
        QUEUED,
        LAUNCHED,
        COMPLETED,
        PAUSED;

    }

    public static enum RecoveredContainerType {
        KILL,
        RECOVER;

    }

    public static class RecoveredApplicationsState {
        RecoveryIterator<YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto> it = null;

        public RecoveryIterator<YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto> getIterator() {
            return this.it;
        }
    }
}

