/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DeadServer {
    private static final Logger LOG = LoggerFactory.getLogger(DeadServer.class);
    private final Map<ServerName, Long> deadServers = new HashMap<ServerName, Long>();
    private final Set<ServerName> processingServers = new HashSet<ServerName>();

    public synchronized boolean isDeadServer(ServerName serverName) {
        return this.deadServers.containsKey(serverName);
    }

    synchronized boolean areDeadServersInProgress() {
        return !this.processingServers.isEmpty();
    }

    public synchronized Set<ServerName> copyServerNames() {
        HashSet<ServerName> clone = new HashSet<ServerName>(this.deadServers.size());
        clone.addAll(this.deadServers.keySet());
        return clone;
    }

    synchronized void putIfAbsent(ServerName sn) {
        this.deadServers.putIfAbsent(sn, EnvironmentEdgeManager.currentTime());
        this.processing(sn);
    }

    public synchronized void processing(ServerName sn) {
        if (this.processingServers.add(sn)) {
            LOG.debug("Processing {}; numProcessing={}", (Object)sn, (Object)this.processingServers.size());
        }
    }

    public synchronized void finish(ServerName sn) {
        if (this.processingServers.remove(sn)) {
            LOG.debug("Removed {} from processing; numProcessing={}", (Object)sn, (Object)this.processingServers.size());
        }
    }

    public synchronized int size() {
        return this.deadServers.size();
    }

    synchronized boolean isEmpty() {
        return this.deadServers.isEmpty();
    }

    synchronized boolean cleanPreviousInstance(ServerName newServerName) {
        Iterator<ServerName> it = this.deadServers.keySet().iterator();
        while (it.hasNext()) {
            if (!this.cleanOldServerName(newServerName, it)) continue;
            return true;
        }
        return false;
    }

    synchronized void cleanAllPreviousInstances(ServerName newServerName) {
        Iterator<ServerName> it = this.deadServers.keySet().iterator();
        while (it.hasNext()) {
            this.cleanOldServerName(newServerName, it);
        }
    }

    private boolean cleanOldServerName(ServerName newServerName, Iterator<ServerName> deadServerIterator) {
        ServerName sn = deadServerIterator.next();
        if (ServerName.isSameAddress(sn, newServerName)) {
            deadServerIterator.remove();
            return true;
        }
        return false;
    }

    public synchronized String toString() {
        HashSet<ServerName> servers = new HashSet<ServerName>();
        servers.addAll(this.deadServers.keySet());
        servers.addAll(this.processingServers);
        StringBuilder sb = new StringBuilder();
        for (ServerName sn : servers) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sn.toString());
            if (!this.processingServers.contains(sn)) continue;
            sb.append("*");
        }
        return sb.toString();
    }

    synchronized List<Pair<ServerName, Long>> copyDeadServersSince(long ts) {
        ArrayList<Pair<ServerName, Long>> res = new ArrayList<Pair<ServerName, Long>>(this.size());
        for (Map.Entry<ServerName, Long> entry : this.deadServers.entrySet()) {
            if (entry.getValue() < ts) continue;
            res.add(new Pair<ServerName, Long>(entry.getKey(), entry.getValue()));
        }
        Collections.sort(res, (o1, o2) -> ((Long)o1.getSecond()).compareTo((Long)o2.getSecond()));
        return res;
    }

    public synchronized Date getTimeOfDeath(ServerName deadServerName) {
        Long time = this.deadServers.get(deadServerName);
        return time == null ? null : new Date(time);
    }

    public synchronized boolean removeDeadServer(ServerName deadServerName) {
        Preconditions.checkState(!this.processingServers.contains(deadServerName), "Asked to remove server still in processingServers set " + deadServerName + " (numProcessing=" + this.processingServers.size() + ")");
        return this.deadServers.remove(deadServerName) != null;
    }
}

