/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DateTieredMultiFileWriter
extends AbstractMultiFileWriter {
    protected final NavigableMap<Long, StoreFileWriter> lowerBoundary2Writer = new TreeMap<Long, StoreFileWriter>();
    private final boolean needEmptyFile;
    private final Map<Long, String> lowerBoundariesPolicies;
    protected Function<Cell, Long> tieringFunction;

    public DateTieredMultiFileWriter(List<Long> lowerBoundaries, Map<Long, String> lowerBoundariesPolicies, boolean needEmptyFile) {
        this(lowerBoundaries, lowerBoundariesPolicies, needEmptyFile, c -> c.getTimestamp());
    }

    public DateTieredMultiFileWriter(List<Long> lowerBoundaries, Map<Long, String> lowerBoundariesPolicies, boolean needEmptyFile, Function<Cell, Long> tieringFunction) {
        for (Long lowerBoundary : lowerBoundaries) {
            this.lowerBoundary2Writer.put(lowerBoundary, null);
        }
        this.needEmptyFile = needEmptyFile;
        this.lowerBoundariesPolicies = lowerBoundariesPolicies;
        this.tieringFunction = tieringFunction;
    }

    @Override
    public void append(Cell cell) throws IOException {
        Map.Entry<Long, StoreFileWriter> entry = this.lowerBoundary2Writer.floorEntry(this.tieringFunction.apply(cell));
        StoreFileWriter writer = entry.getValue();
        if (writer == null) {
            String lowerBoundaryStoragePolicy = this.lowerBoundariesPolicies.get(entry.getKey());
            writer = lowerBoundaryStoragePolicy != null ? this.writerFactory.createWriterWithStoragePolicy(lowerBoundaryStoragePolicy) : this.writerFactory.createWriter();
            this.lowerBoundary2Writer.put(entry.getKey(), writer);
        }
        writer.append(cell);
    }

    @Override
    protected Collection<StoreFileWriter> writers() {
        return this.lowerBoundary2Writer.values();
    }

    @Override
    protected void preCommitWriters() throws IOException {
        if (!this.needEmptyFile) {
            return;
        }
        for (StoreFileWriter writer : this.lowerBoundary2Writer.values()) {
            if (writer == null) continue;
            return;
        }
        this.lowerBoundary2Writer.put((Long)this.lowerBoundary2Writer.firstKey(), this.writerFactory.createWriter());
    }
}

