/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class DataBlockEncodingValidator
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(DataBlockEncodingValidator.class);
    private static final byte[] DATA_BLOCK_ENCODING = Bytes.toBytes("DATA_BLOCK_ENCODING");

    private int validateDBE() throws IOException {
        int incompatibilities = 0;
        LOG.info("Validating Data Block Encodings");
        try (Connection connection = ConnectionFactory.createConnection(this.getConf());
             Admin admin = connection.getAdmin();){
            List<TableDescriptor> tableDescriptors = admin.listTableDescriptors();
            String encoding = "";
            for (TableDescriptor td : tableDescriptors) {
                ColumnFamilyDescriptor[] columnFamilies;
                for (ColumnFamilyDescriptor cfd : columnFamilies = td.getColumnFamilies()) {
                    try {
                        encoding = Bytes.toString(cfd.getValue(DATA_BLOCK_ENCODING));
                        DataBlockEncoding.valueOf(encoding);
                    }
                    catch (IllegalArgumentException e) {
                        ++incompatibilities;
                        LOG.warn("Incompatible DataBlockEncoding for table: {}, cf: {}, encoding: {}", new Object[]{td.getTableName().getNameAsString(), cfd.getNameAsString(), encoding});
                    }
                }
            }
        }
        if (incompatibilities > 0) {
            LOG.warn("There are {} column families with incompatible Data Block Encodings. Do not upgrade until these encodings are converted to a supported one. Check https://s.apache.org/prefixtree for instructions.", (Object)incompatibilities);
        } else {
            LOG.info("The used Data Block Encodings are compatible with HBase 2.0.");
        }
        return incompatibilities;
    }

    @Override
    protected void printUsage() {
        String header = "hbase pre-upgrade validate-dbe";
        this.printUsage(header, null, "");
    }

    @Override
    protected void addOptions() {
    }

    @Override
    protected void processOptions(CommandLine cmd) {
    }

    @Override
    protected int doWork() throws Exception {
        return this.validateDBE() == 0 ? 0 : 1;
    }
}

