/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRSGroupConfig
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupConfig.class);
    @Rule
    public TestName name = new TestName();
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupConfig.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestRSGroupsBase.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestRSGroupsBase.tearDownAfterClass();
    }

    @Test
    public void testSetDefaultGroupConfiguration() {
        Assert.assertThrows(ConstraintException.class, () -> this.testSetConfiguration("default"));
    }

    @Test
    public void testSetNonDefaultGroupConfiguration() throws IOException {
        String group = this.getGroupName(this.name.getMethodName());
        rsGroupAdmin.addRSGroup(group);
        this.testSetConfiguration(group);
        rsGroupAdmin.removeRSGroup(group);
    }

    private void testSetConfiguration(String group) throws IOException {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("aaa", "111");
        configuration.put("bbb", "222");
        rsGroupAdmin.updateRSGroupConfig(group, configuration);
        RSGroupInfo rsGroup = rsGroupAdmin.getRSGroupInfo(group);
        Assert.assertEquals(configuration, (Object)rsGroup.getConfiguration());
        rsGroupAdmin.updateRSGroupConfig(group, null);
        rsGroup = rsGroupAdmin.getRSGroupInfo(group);
        Map configFromGroup = rsGroup.getConfiguration();
        Assert.assertNotNull((Object)configFromGroup);
        Assert.assertEquals((long)0L, (long)configFromGroup.size());
    }
}

