/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import org.apache.hadoop.hbase.replication.regionserver.SerialReplicationChecker;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SerialReplicationSourceWALReader
extends ReplicationSourceWALReader {
    private static final Logger LOG = LoggerFactory.getLogger(SerialReplicationSourceWALReader.class);
    private Cell firstCellInEntryBeforeFiltering;
    private final SerialReplicationChecker checker;

    public SerialReplicationSourceWALReader(FileSystem fs, Configuration conf, ReplicationSourceLogQueue logQueue, long startPosition, WALEntryFilter filter, ReplicationSource source, String walGroupId) {
        super(fs, conf, logQueue, startPosition, filter, source, walGroupId);
        this.checker = new SerialReplicationChecker(conf, source);
    }

    @Override
    protected void readWALEntries(WALEntryStream entryStream, WALEntryBatch batch) throws InterruptedException {
        block11: {
            WALEntryStream.HasNext hasNext;
            Path currentPath = entryStream.getCurrentPath();
            long positionBefore = entryStream.getPosition();
            do {
                WAL.Entry entry = entryStream.peek();
                boolean doFiltering = true;
                if (this.firstCellInEntryBeforeFiltering == null) {
                    assert (!entry.getEdit().isEmpty()) : "should not write empty edits";
                    this.firstCellInEntryBeforeFiltering = entry.getEdit().getCells().get(0);
                } else {
                    doFiltering = false;
                }
                if (doFiltering) {
                    entry = this.filterEntry(entry);
                }
                if (entry != null) {
                    block10: {
                        int sleepMultiplier = 1;
                        try {
                            if (this.checker.canPush(entry, this.firstCellInEntryBeforeFiltering)) break block10;
                            if (batch.getLastWalPosition() > positionBefore) break block11;
                            this.checker.waitUntilCanPush(entry, this.firstCellInEntryBeforeFiltering);
                        }
                        catch (IOException e) {
                            LOG.warn("failed to check whether we can push the WAL entries", (Throwable)e);
                            if (batch.getLastWalPosition() > positionBefore) break block11;
                            sleepMultiplier = this.sleep(sleepMultiplier);
                        }
                    }
                    this.removeEntryFromStream(entry, entryStream, batch);
                    if (this.addEntryToBatch(batch, entry)) {
                        break;
                    }
                } else {
                    this.removeEntryFromStream(null, entryStream, batch);
                }
                hasNext = entryStream.hasNext();
                if (!SerialReplicationSourceWALReader.switched(entryStream, currentPath)) continue;
                batch.setEndOfFile(true);
                break;
            } while (hasNext == WALEntryStream.HasNext.YES);
        }
    }

    private void removeEntryFromStream(WAL.Entry entry, WALEntryStream entryStream, WALEntryBatch batch) {
        entryStream.next();
        batch.setLastWalPosition(entryStream.getPosition());
        if (entry != null) {
            batch.setLastSeqId(Bytes.toString((byte[])entry.getKey().getEncodedRegionName()), entry.getKey().getSequenceId());
        }
        this.firstCellInEntryBeforeFiltering = null;
    }
}

