/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.JMXListener;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestJMXListener {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestJMXListener.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestJMXListener.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static int CONNECTOR_PORT;
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        System.setProperty("sun.rmi.transport.connectionTimeout", Integer.toString(5000));
        System.setProperty("sun.rmi.transport.tcp.handshakeTimeout", Integer.toString(5000));
        System.setProperty("sun.rmi.transport.tcp.responseTimeout", Integer.toString(5000));
        System.setProperty("sun.rmi.transport.tcp.readTimeout", Integer.toString(5000));
        Configuration conf = UTIL.getConfiguration();
        Object bsm = null;
        conf.set("hbase.coprocessor.regionserver.classes", JMXListener.class.getName());
        CONNECTOR_PORT = bsm == null ? HBaseTestingUtility.randomFreePort() : bsm.getPort();
        for (int i = 0; i < 10; ++i) {
            conf.setInt("regionserver.rmi.registry.port", CONNECTOR_PORT);
            UTIL.startMiniCluster();
            try (JMXConnector connector = null;){
                connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)CONNECTOR_PORT, (int)CONNECTOR_PORT));
                break;
            }
        }
        if (bsm != null) {
            bsm.close();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testStart() throws Exception {
        JMXConnector connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)CONNECTOR_PORT, (int)CONNECTOR_PORT));
        MBeanServerConnection mb = connector.getMBeanServerConnection();
        String domain = mb.getDefaultDomain();
        Assert.assertTrue((String)"default domain is not correct", (!domain.isEmpty() ? 1 : 0) != 0);
        connector.close();
    }

    @Test
    public void testStop() throws Exception {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        LOG.info("shutdown hbase cluster...");
        cluster.shutdown();
        LOG.info("wait for the hbase cluster shutdown...");
        cluster.waitUntilShutDown();
        JMXConnector connector = JMXConnectorFactory.newJMXConnector(JMXListener.buildJMXServiceURL((int)CONNECTOR_PORT, (int)CONNECTOR_PORT), null);
        this.expectedEx.expect(IOException.class);
        connector.connect();
    }

    @Test
    public void testGetRegionServerCoprocessors() throws Exception {
        for (JVMClusterUtil.RegionServerThread rs : UTIL.getHBaseCluster().getRegionServerThreads()) {
            boolean find = false;
            for (String s : rs.getRegionServer().getRegionServerCoprocessors()) {
                if (!s.equals(JMXListener.class.getSimpleName())) continue;
                find = true;
                break;
            }
            if (find) continue;
            Assert.fail((String)"where is the JMXListener?");
        }
    }
}

