/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.hadoop.hbase.ipc.NettyRpcFrameDecoder;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RPCTests.class, MediumTests.class})
public class TestNettyIPCCloseConnection {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyIPCCloseConnection.class);
    private static Configuration CONF = HBaseConfiguration.create();
    private NioEventLoopGroup group;
    private NettyRpcServer server;
    private NettyRpcClient client;
    private TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub;

    @Before
    public void setUp() throws IOException {
        this.group = new NioEventLoopGroup();
        this.server = new NettyRpcServer(null, this.getClass().getSimpleName(), (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1), true);
        NettyRpcClientConfigHelper.setEventLoopConfig((Configuration)CONF, (EventLoopGroup)this.group, NioSocketChannel.class);
        this.client = new NettyRpcClient(CONF);
        this.server.start();
        this.stub = TestProtobufRpcServiceImpl.newBlockingStub((RpcClient)this.client, this.server.getListenerAddress());
    }

    @After
    public void tearDown() throws Exception {
        Closeables.close((Closeable)this.client, (boolean)true);
        this.server.stop();
        this.group.shutdownGracefully().sync();
    }

    @Test
    public void test() throws Exception {
        HBaseSaslRpcServer saslServer;
        Assert.assertEquals((Object)"test", (Object)this.stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("test").build()).getMessage());
        Channel channel = (Channel)Iterators.getOnlyElement((Iterator)this.server.allChannels.iterator());
        Assert.assertNotNull((Object)channel);
        NettyRpcFrameDecoder decoder = (NettyRpcFrameDecoder)channel.pipeline().get(NettyRpcFrameDecoder.class);
        decoder.connection.saslServer = saslServer = (HBaseSaslRpcServer)Mockito.mock(HBaseSaslRpcServer.class);
        this.client.close();
        channel.closeFuture().await(5L, TimeUnit.SECONDS);
        Waiter.waitFor((Configuration)CONF, (long)5000L, () -> decoder.connection.saslServer == null);
        ((HBaseSaslRpcServer)Mockito.verify((Object)saslServer, (VerificationMode)Mockito.times((int)1))).dispose();
    }
}

