/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.CacheAwareLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCacheAwareLoadBalancerCostFunctions
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCacheAwareLoadBalancerCostFunctions.class);
    private final float[] expectedCacheCost = new float[]{0.0f, 0.0f, 0.5f, 1.0f, 0.0f, 0.572f, 0.0f, 0.075f};
    private final int[][][] clusterRegionCacheRatioMocks = new int[][][]{new int[][]{{2, 1, 1}, {0, 100, 0, 0}, {0, 100, 0, 0}, {1, 0, 100, 0}, {2, 0, 0, 100}}, new int[][]{{1, 2, 1}, {0, 100, 0, 100}, {1, 100, 100, 0}, {1, 0, 100, 100}, {2, 0, 100, 100}}, new int[][]{{1, 2, 1}, {0, 50, 0, 100}, {1, 100, 50, 0}, {1, 0, 50, 100}, {2, 0, 100, 50}}, new int[][]{{1, 1, 2}, {0, 0, 0, 100}, {1, 100, 0, 0}, {2, 0, 100, 0}, {2, 100, 0, 0}}, new int[][]{{2, 1, 1}, {0, 50, 50, 0}, {0, 50, 0, 50}, {1, 0, 50, 50}, {2, 0, 50, 50}}, new int[][]{{1, 2, 1}, {0, 30, 70, 0}, {1, 70, 30, 0}, {1, 0, 30, 70}, {2, 0, 70, 30}}, new int[][]{{2, 1, 1}, {0, 80, 20, 0}, {0, 80, 0, 20}, {1, 20, 80, 0}, {2, 0, 20, 80}}, new int[][]{{1, 2, 1}, {0, 34, 0, 58}, {1, 78, 100, 0}, {1, 66, 66, 0}, {2, 0, 0, 96}}};
    private static Configuration storedConfiguration;
    private final CacheAwareLoadBalancer loadBalancer = new CacheAwareLoadBalancer();
    private MasterServices services;

    @BeforeClass
    public static void saveInitialConfiguration() {
        storedConfiguration = new Configuration(conf);
    }

    @Before
    public void beforeEachTest() {
        conf = new Configuration(storedConfiguration);
        this.services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)this.services.getConfiguration()).thenReturn((Object)conf);
        this.loadBalancer.setMasterServices(this.services);
        this.loadBalancer.loadConf(conf);
    }

    @Test
    public void testVerifyCacheAwareSkewnessCostFunctionEnabled() {
        CacheAwareLoadBalancer lb = new CacheAwareLoadBalancer();
        lb.setMasterServices(this.services);
        lb.loadConf(conf);
        Assert.assertTrue((boolean)Arrays.asList(lb.getCostFunctionNames()).contains(CacheAwareLoadBalancer.CacheAwareRegionSkewnessCostFunction.class.getSimpleName()));
    }

    @Test
    public void testVerifyCacheAwareSkewnessCostFunctionDisabled() {
        conf.setFloat("hbase.master.balancer.stochastic.regionCountCost", 0.0f);
        CacheAwareLoadBalancer lb = new CacheAwareLoadBalancer();
        lb.setMasterServices(this.services);
        lb.loadConf(conf);
        Assert.assertFalse((boolean)Arrays.asList(lb.getCostFunctionNames()).contains(CacheAwareLoadBalancer.CacheAwareRegionSkewnessCostFunction.class.getSimpleName()));
    }

    @Test
    public void testVerifyCacheCostFunctionEnabled() {
        conf.set("hbase.bucketcache.persistent.path", "/tmp/prefetch.persistence");
        CacheAwareLoadBalancer lb = new CacheAwareLoadBalancer();
        lb.setMasterServices(this.services);
        lb.loadConf(conf);
        Assert.assertTrue((boolean)Arrays.asList(lb.getCostFunctionNames()).contains(CacheAwareLoadBalancer.CacheAwareCostFunction.class.getSimpleName()));
    }

    @Test
    public void testVerifyCacheCostFunctionDisabledByNoBucketCachePersistence() {
        Assert.assertFalse((boolean)Arrays.asList(this.loadBalancer.getCostFunctionNames()).contains(CacheAwareLoadBalancer.CacheAwareCostFunction.class.getSimpleName()));
    }

    @Test
    public void testVerifyCacheCostFunctionDisabledByNoMultiplier() {
        conf.set("hbase.bucketcache.persistent.path", "/tmp/prefetch.persistence");
        conf.setFloat("hbase.master.balancer.stochastic.cacheCost", 0.0f);
        Assert.assertFalse((boolean)Arrays.asList(this.loadBalancer.getCostFunctionNames()).contains(CacheAwareLoadBalancer.CacheAwareCostFunction.class.getSimpleName()));
    }

    @Test
    public void testCacheCost() {
        conf.set("hbase.bucketcache.persistent.path", "/tmp/prefetch.persistence");
        CacheAwareLoadBalancer.CacheAwareCostFunction costFunction = new CacheAwareLoadBalancer.CacheAwareCostFunction(conf);
        for (int test = 0; test < this.clusterRegionCacheRatioMocks.length; ++test) {
            int[][] clusterRegionLocations = this.clusterRegionCacheRatioMocks[test];
            MockClusterForCacheCost cluster = new MockClusterForCacheCost(clusterRegionLocations);
            costFunction.prepare((BalancerClusterState)cluster);
            double cost = costFunction.cost();
            Assert.assertEquals((double)this.expectedCacheCost[test], (double)cost, (double)0.01);
        }
    }

    private class MockClusterForCacheCost
    extends BalancerClusterState {
        private final Map<Pair<Integer, Integer>, Float> regionServerCacheRatio;

        public MockClusterForCacheCost(int[][] regionsArray) {
            super(TestCacheAwareLoadBalancerCostFunctions.this.mockClusterServersUnsorted(regionsArray[0], 1), null, null, null, null);
            this.regionServerCacheRatio = new HashMap<Pair<Integer, Integer>, Float>();
            HashMap<String, Pair> oldCacheRatio = new HashMap<String, Pair>();
            for (int i = 1; i < regionsArray.length; ++i) {
                int regionIndex = i - 1;
                for (int j = 1; j < regionsArray[i].length; ++j) {
                    int serverIndex = j - 1;
                    float cacheRatio = (float)regionsArray[i][j] / 100.0f;
                    this.regionServerCacheRatio.put((Pair<Integer, Integer>)new Pair((Object)regionIndex, (Object)serverIndex), Float.valueOf(cacheRatio));
                    if (!(cacheRatio > 0.0f) || serverIndex == regionsArray[i][0]) continue;
                    oldCacheRatio.put(this.regions[regionIndex].getEncodedName(), new Pair((Object)this.servers[serverIndex], (Object)Float.valueOf(cacheRatio)));
                }
            }
            this.regionCacheRatioOnOldServerMap = oldCacheRatio;
        }

        public int getTotalRegionHFileSizeMB(int region) {
            return 1;
        }

        protected float getRegionCacheRatioOnRegionServer(int region, int regionServerIndex) {
            Pair serverCacheRatio;
            float cacheRatio = 0.0f;
            if (regionServerIndex == this.regionIndexToServerIndex[region]) {
                return this.regionServerCacheRatio.get(new Pair((Object)region, (Object)regionServerIndex)).floatValue();
            }
            String regionEncodedName = this.regions[region].getEncodedName();
            ServerName serverName = this.servers[regionServerIndex];
            if (this.regionCacheRatioOnOldServerMap != null && this.regionCacheRatioOnOldServerMap.containsKey(regionEncodedName) && ServerName.isSameAddress((ServerName)serverName, (ServerName)((ServerName)(serverCacheRatio = (Pair)this.regionCacheRatioOnOldServerMap.get(regionEncodedName)).getFirst()))) {
                cacheRatio = ((Float)serverCacheRatio.getSecond()).floatValue();
                this.regionCacheRatioOnOldServerMap.remove(regionEncodedName);
            }
            return cacheRatio;
        }
    }
}

