/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.AnswersWithDelay;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedure {
    protected static final Logger LOG = LoggerFactory.getLogger(TestSnapshotProcedure.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedure.class);
    protected static HBaseTestingUtility TEST_UTIL;
    protected HMaster master;
    protected TableName TABLE_NAME;
    protected byte[] CF;
    protected String SNAPSHOT_NAME;
    protected SnapshotDescription snapshot;
    protected SnapshotProtos.SnapshotDescription snapshotProto;
    protected Admin admin;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        Configuration config = TEST_UTIL.getConfiguration();
        config.setInt("hbase.snapshot.remote.verify.threshold", 1);
        config.setInt("hbase.procedure.remote.dispatcher.delay.msec", 10000);
        config.setInt("hbase.procedure.remote.dispatcher.max.queue.size", 128);
        TEST_UTIL.startMiniCluster(3);
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        this.admin = TEST_UTIL.getAdmin();
        this.TABLE_NAME = TableName.valueOf((byte[])Bytes.toBytes((String)"SPTestTable"));
        this.CF = Bytes.toBytes((String)"cf");
        this.SNAPSHOT_NAME = "SnapshotProcedureTest";
        this.snapshot = new SnapshotDescription(this.SNAPSHOT_NAME, this.TABLE_NAME, SnapshotType.FLUSH);
        this.snapshotProto = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)this.snapshot);
        this.snapshotProto = SnapshotDescriptionUtils.validate((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Configuration)this.master.getConfiguration());
        byte[][] splitKeys = new RegionSplitter.HexStringSplit().split(10);
        Table table = TEST_UTIL.createTable(this.TABLE_NAME, this.CF, splitKeys);
        TEST_UTIL.loadTable(table, this.CF, false);
    }

    public <T extends Procedure<MasterProcedureEnv>> T waitProcedureRunnableAndGetFirst(Class<T> clazz, long timeout) throws IOException {
        TEST_UTIL.waitFor(timeout, () -> this.master.getProcedures().stream().anyMatch(clazz::isInstance));
        Optional<Procedure> procOpt = this.master.getMasterProcedureExecutor().getProcedures().stream().filter(clazz::isInstance).map(clazz::cast).findFirst();
        Assert.assertTrue((boolean)procOpt.isPresent());
        return (T)procOpt.get();
    }

    protected SnapshotProcedure getDelayedOnSpecificStateSnapshotProcedure(SnapshotProcedure sp, MasterProcedureEnv env, MasterProcedureProtos.SnapshotState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        SnapshotProcedure spySp = (SnapshotProcedure)Mockito.spy((Object)sp);
        ((SnapshotProcedure)Mockito.doAnswer((Answer)new AnswersWithDelay(60000L, (Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return invocation.callRealMethod();
            }
        })).when((Object)spySp)).executeFromState(env, state);
        return spySp;
    }

    @After
    public void teardown() throws Exception {
        if (this.master != null) {
            ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (boolean)false);
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    public static final class DelaySnapshotProcedure
    extends SnapshotProcedure {
        public DelaySnapshotProcedure() {
        }

        public DelaySnapshotProcedure(MasterProcedureEnv env, SnapshotProtos.SnapshotDescription snapshot) {
            super(env, snapshot);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SnapshotState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            StateMachineProcedure.Flow flow = super.executeFromState(env, state);
            if (state == MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_ONLINE_REGIONS) {
                TimeUnit.SECONDS.sleep(20L);
            }
            return flow;
        }
    }
}

