/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomRsAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartRandomRsExceptMetaAction
extends RestartRandomRsAction {
    private static final Logger LOG = LoggerFactory.getLogger(RestartRandomRsExceptMetaAction.class);

    public RestartRandomRsExceptMetaAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        int tries = 10;
        while (tries-- > 0 && this.getCurrentServers().length > 1) {
            ServerName server = PolicyBasedChaosMonkey.selectRandomItem(this.getCurrentServers());
            ServerName metaServer = this.cluster.getServerHoldingMeta();
            if (server == null || server.equals((Object)metaServer)) continue;
            this.restartRs(server, this.sleepTime);
            break;
        }
    }
}

