/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestSymlinkHdfs;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSymlinkHdfsFileContext
extends TestSymlinkHdfs {
    private static FileContext fc;

    @BeforeClass
    public static void testSetup() throws Exception {
        fc = FileContext.getFileContext((URI)cluster.getURI(0));
        wrapper = new FileContextTestWrapper(fc, "/tmp/TestSymlinkHdfsFileContext");
    }

    @Test(timeout=10000L)
    public void testAccessLinkFromAbstractFileSystem() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "linkToFile");
        TestSymlinkHdfsFileContext.createAndWriteFile((Path)file);
        wrapper.createSymlink(file, link, false);
        try {
            AbstractFileSystem afs = fc.getDefaultFileSystem();
            afs.open(link);
            Assert.fail((String)"Opened a link using AFS");
        }
        catch (UnresolvedLinkException unresolvedLinkException) {
            // empty catch block
        }
    }
}

