/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.InClauseBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.AddWriteIdsToTxnToWriteIdCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortTxnFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.TargetTxnIdListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class AllocateTableWriteIdsFunction
implements TransactionalFunction<AllocateTableWriteIdsResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(AbortTxnFunction.class);
    private final AllocateTableWriteIdsRequest rqst;
    private final List<TransactionalMetaStoreEventListener> transactionalListeners;

    public AllocateTableWriteIdsFunction(AllocateTableWriteIdsRequest rqst, List<TransactionalMetaStoreEventListener> transactionalListeners) {
        this.rqst = rqst;
        this.transactionalListeners = transactionalListeners;
    }

    @Override
    public AllocateTableWriteIdsResponse execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        Long nextWriteId;
        long writeId;
        List<Long> txnIds;
        String dbName = this.rqst.getDbName().toLowerCase();
        String tblName = this.rqst.getTableName().toLowerCase();
        boolean shouldReallocate = this.rqst.isReallocate();
        Connection dbConn = jdbcResource.getConnection();
        ArrayList<TxnToWriteId> txnToWriteIds = new ArrayList<TxnToWriteId>();
        List srcTxnToWriteIds = null;
        if (this.rqst.isSetReplPolicy()) {
            srcTxnToWriteIds = this.rqst.getSrcTxnToWriteIdList();
            ArrayList<Long> srcTxnIds = new ArrayList<Long>();
            assert (this.rqst.isSetSrcTxnToWriteIdList());
            assert (!this.rqst.isSetTxnIds());
            assert (!srcTxnToWriteIds.isEmpty());
            for (TxnToWriteId txnToWriteId : srcTxnToWriteIds) {
                srcTxnIds.add(txnToWriteId.getTxnId());
            }
            txnIds = jdbcResource.execute(new TargetTxnIdListHandler(this.rqst.getReplPolicy(), srcTxnIds));
            if (srcTxnIds.size() != txnIds.size()) {
                LOG.info("Idempotent case: Target txn id is missing for source txn id : {} and repl policy {}", srcTxnIds, (Object)this.rqst.getReplPolicy());
                return new AllocateTableWriteIdsResponse(txnToWriteIds);
            }
        } else {
            assert (!this.rqst.isSetSrcTxnToWriteIdList());
            assert (this.rqst.isSetTxnIds());
            txnIds = this.rqst.getTxnIds();
        }
        if (txnIds.size() > 1) {
            Collections.sort(txnIds);
        }
        if (!this.isTxnsOpenAndNotReadOnly(jdbcResource, txnIds)) {
            String errorMsg = "Write ID allocation on " + TableName.getDbTable((String)dbName, (String)tblName) + " failed for input txns: " + this.getAbortedAndReadOnlyTxns(jdbcResource, txnIds) + this.getCommittedTxns(jdbcResource, txnIds);
            LOG.error(errorMsg);
            throw new IllegalStateException("Write ID allocation failed on " + TableName.getDbTable((String)dbName, (String)tblName) + " as not all input txns in open state or read-only");
        }
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        int allocatedTxnsCount = 0;
        List<String> params = Arrays.asList(dbName, tblName);
        if (shouldReallocate) {
            jdbcResource.execute(new InClauseBatchCommand("DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = :dbName AND \"T2W_TABLE\" = :tableName AND \"T2W_TXNID\" IN (:txnIds)", (SqlParameterSource)new MapSqlParameterSource().addValue("dbName", (Object)dbName).addValue("tableName", (Object)tblName).addValue("txnIds", txnIds), "txnIds", Long::compareTo));
        } else {
            prefix.append("SELECT \"T2W_TXNID\", \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE").append(" \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND ");
            TxnUtils.buildQueryWithINClause(jdbcResource.getConf(), queries, prefix, suffix, txnIds, "\"T2W_TXNID\"", false, false);
            for (String query : queries) {
                try {
                    PreparedStatement pStmt = jdbcResource.getSqlGenerator().prepareStmtWithParameters(dbConn, query, params);
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Going to execute query <" + query.replace("?", "'{}'") + ">", (Object)dbName, (Object)tblName);
                        }
                        ResultSet rs2 = pStmt.executeQuery();
                        try {
                            while (rs2.next()) {
                                long txnId = rs2.getLong(1);
                                writeId = rs2.getLong(2);
                                txnToWriteIds.add(new TxnToWriteId(txnId, writeId));
                                ++allocatedTxnsCount;
                                LOG.info("Reused already allocated writeID: {} for txnId: {}", (Object)writeId, (Object)txnId);
                            }
                        }
                        finally {
                            if (rs2 == null) continue;
                            rs2.close();
                        }
                    }
                    finally {
                        if (pStmt == null) continue;
                        pStmt.close();
                    }
                }
                catch (SQLException e) {
                    throw new UncategorizedSQLException(null, null, e);
                }
            }
        }
        long numOfWriteIds = txnIds.size();
        assert (allocatedTxnsCount == 0 || numOfWriteIds == (long)allocatedTxnsCount);
        if ((long)allocatedTxnsCount == numOfWriteIds) {
            return new AllocateTableWriteIdsResponse(txnToWriteIds);
        }
        long srcWriteId = 0L;
        if (this.rqst.isSetReplPolicy()) {
            assert (srcTxnToWriteIds != null);
            srcWriteId = ((TxnToWriteId)srcTxnToWriteIds.get(0)).getWriteId();
        }
        String query = jdbcResource.getSqlGenerator().addForUpdateClause("SELECT \"NWI_NEXT\" FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = :dbName AND \"NWI_TABLE\" = :tableName");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Going to execute query {}", (Object)query);
        }
        if ((nextWriteId = (Long)jdbcResource.getJdbcTemplate().query(query, (SqlParameterSource)new MapSqlParameterSource().addValue("dbName", (Object)dbName).addValue("tableName", (Object)tblName), rs -> rs.next() ? Long.valueOf(rs.getLong(1)) : null)) == null) {
            query = "INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (:dbName, :tableName, :nextId)";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query {}", (Object)query);
            }
            writeId = srcWriteId > 0L ? srcWriteId : 1L;
            jdbcResource.getJdbcTemplate().update(query, (SqlParameterSource)new MapSqlParameterSource().addValue("dbName", (Object)dbName).addValue("tableName", (Object)tblName).addValue("nextId", (Object)(writeId + numOfWriteIds)));
        } else {
            query = "UPDATE \"NEXT_WRITE_ID\" SET \"NWI_NEXT\" = :nextId WHERE \"NWI_DATABASE\" = :dbName AND \"NWI_TABLE\" = :tableName";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query {}", (Object)query);
            }
            writeId = srcWriteId > 0L ? srcWriteId : nextWriteId;
            jdbcResource.getJdbcTemplate().update(query, (SqlParameterSource)new MapSqlParameterSource().addValue("dbName", (Object)dbName).addValue("tableName", (Object)tblName).addValue("nextId", (Object)(writeId + numOfWriteIds)));
            if (srcWriteId > 0L && srcWriteId != nextWriteId) {
                query = "DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = :dbName AND \"T2W_TABLE\" = :tableName";
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute query {}", (Object)query);
                }
                jdbcResource.getJdbcTemplate().update(query, (SqlParameterSource)new MapSqlParameterSource().addValue("dbName", (Object)dbName).addValue("tableName", (Object)tblName));
            }
        }
        jdbcResource.execute(new AddWriteIdsToTxnToWriteIdCommand(dbName, tblName, writeId, txnIds, txnToWriteIds));
        if (this.transactionalListeners != null) {
            MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ALLOC_WRITE_ID, new AllocWriteIdEvent(txnToWriteIds, dbName, tblName), dbConn, jdbcResource.getSqlGenerator());
        }
        LOG.info("Allocated write ids for dbName={}, tblName={} (txnIds: {})", new Object[]{dbName, tblName, this.rqst.getTxnIds()});
        return new AllocateTableWriteIdsResponse(txnToWriteIds);
    }

    private boolean isTxnsOpenAndNotReadOnly(MultiDataSourceJdbcResource jdbcResource, List<Long> txnIds) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT COUNT(*) FROM \"TXNS\" WHERE \"TXN_STATE\" = ").append((Object)TxnStatus.OPEN).append(" AND \"TXN_TYPE\" != ").append(TxnType.READ_ONLY.getValue()).append(" AND ");
        TxnUtils.buildQueryWithINClause(jdbcResource.getConf(), queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
        AtomicLong count = new AtomicLong(0L);
        for (String query : queries) {
            LOG.debug("Going to execute query <{}>", (Object)query);
            jdbcResource.getJdbcTemplate().query(query, rs -> {
                while (rs.next()) {
                    count.set(count.get() + rs.getLong(1));
                }
                return null;
            });
        }
        return count.get() == (long)txnIds.size();
    }

    private String getAbortedAndReadOnlyTxns(MultiDataSourceJdbcResource jdbcResource, List<Long> txnIds) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\" FROM \"TXNS\" WHERE ");
        TxnUtils.buildQueryWithINClause(jdbcResource.getConf(), queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
        StringBuilder txnInfo = new StringBuilder();
        for (String query : queries) {
            LOG.debug("Going to execute query <{}>", (Object)query);
            jdbcResource.getJdbcTemplate().query(query, rs -> {
                while (rs.next()) {
                    long txnId = rs.getLong(1);
                    TxnStatus txnState = TxnStatus.fromString(rs.getString(2));
                    TxnType txnType = TxnType.findByValue((int)rs.getInt(3));
                    if (txnState != TxnStatus.OPEN) {
                        txnInfo.append("{").append(txnId).append(",").append((Object)txnState).append("}");
                        continue;
                    }
                    if (txnType != TxnType.READ_ONLY) continue;
                    txnInfo.append("{").append(txnId).append(",read-only}");
                }
                return null;
            });
        }
        return txnInfo.toString();
    }

    private String getCommittedTxns(MultiDataSourceJdbcResource jdbcResource, List<Long> txnIds) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT \"CTC_TXNID\" FROM \"COMPLETED_TXN_COMPONENTS\" WHERE ");
        TxnUtils.buildQueryWithINClause(jdbcResource.getConf(), queries, prefix, new StringBuilder(), txnIds, "\"CTC_TXNID\"", false, false);
        StringBuilder txnInfo = new StringBuilder();
        for (String query : queries) {
            LOG.debug("Going to execute query <{}>", (Object)query);
            jdbcResource.getJdbcTemplate().query(query, rs -> {
                while (rs.next()) {
                    long txnId = rs.getLong(1);
                    txnInfo.append("{").append(txnId).append(",c}");
                }
                return null;
            });
        }
        return txnInfo.toString();
    }
}

