/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hive.common.MaterializationSnapshot;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.GetValidWriteIdsForTableFunction;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMaterializationInvalidationInfoFunction
implements TransactionalFunction<Materialization> {
    private static final Logger LOG = LoggerFactory.getLogger(GetMaterializationInvalidationInfoFunction.class);
    private final CreationMetadata creationMetadata;
    private final String validTxnListStr;

    public GetMaterializationInvalidationInfoFunction(CreationMetadata creationMetadata, String validTxnListStr) {
        this.creationMetadata = creationMetadata;
        this.validTxnListStr = validTxnListStr;
    }

    @Override
    public Materialization execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        if (this.creationMetadata.getTablesUsed().isEmpty()) {
            LOG.warn("Materialization creation metadata does not contain any table");
            return null;
        }
        MaterializationSnapshot mvSnapshot = MaterializationSnapshot.fromJson((String)this.creationMetadata.getValidTxnList());
        if (mvSnapshot.getTableSnapshots() != null && !mvSnapshot.getTableSnapshots().isEmpty()) {
            return null;
        }
        ValidTxnWriteIdList validReaderWriteIdList = ValidTxnWriteIdList.fromValue((String)mvSnapshot.getValidTxnList());
        ValidReadTxnList currentValidTxnList = ValidReadTxnList.fromValue((String)this.validTxnListStr);
        ArrayList<TableValidWriteIds> currentTblValidWriteIdsList = new ArrayList<TableValidWriteIds>();
        for (String fullTableName : this.creationMetadata.getTablesUsed()) {
            currentTblValidWriteIdsList.add(new GetValidWriteIdsForTableFunction((ValidTxnList)currentValidTxnList, fullTableName).execute(jdbcResource));
        }
        ValidTxnWriteIdList currentValidReaderWriteIdList = TxnCommonUtils.createValidTxnWriteIdList((Long)currentValidTxnList.getHighWatermark(), currentTblValidWriteIdsList);
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder queryUpdateDelete = new StringBuilder();
        StringBuilder queryCompletedCompactions = new StringBuilder();
        StringBuilder queryCompactionQueue = new StringBuilder();
        queryUpdateDelete.append("SELECT \"CTC_UPDATE_DELETE\" FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_UPDATE_DELETE\" ='Y' AND (");
        queryCompletedCompactions.append("SELECT 1 FROM \"COMPLETED_COMPACTIONS\" WHERE (");
        queryCompactionQueue.append("SELECT 1 FROM \"COMPACTION_QUEUE\" WHERE (");
        int i = 0;
        for (String fullyQualifiedName : this.creationMetadata.getTablesUsed()) {
            ValidWriteIdList tblValidWriteIdList = validReaderWriteIdList.getTableValidWriteIdList(fullyQualifiedName);
            if (tblValidWriteIdList == null) {
                LOG.warn("ValidWriteIdList for table {} not present in creation metadata, this should not happen", (Object)fullyQualifiedName);
                return null;
            }
            ValidWriteIdList currentTblValidWriteIdList = currentValidReaderWriteIdList.getTableValidWriteIdList(fullyQualifiedName);
            if (currentTblValidWriteIdList == null) {
                LOG.warn("Current ValidWriteIdList for table {} not present in creation metadata, this should not happen", (Object)fullyQualifiedName);
                return null;
            }
            if (!Objects.equals(currentTblValidWriteIdList.getMinOpenWriteId(), tblValidWriteIdList.getMinOpenWriteId())) {
                LOG.debug("Minimum open write id do not match for table {}", (Object)fullyQualifiedName);
                return null;
            }
            if (i != 0) {
                queryUpdateDelete.append("OR");
                queryCompletedCompactions.append("OR");
                queryCompactionQueue.append("OR");
            }
            String[] names = TxnUtils.getDbTableName(fullyQualifiedName);
            assert (names.length == 2);
            queryUpdateDelete.append(" (\"CTC_DATABASE\"=? AND \"CTC_TABLE\"=?");
            queryCompletedCompactions.append(" (\"CC_DATABASE\"=? AND \"CC_TABLE\"=?");
            queryCompactionQueue.append(" (\"CQ_DATABASE\"=? AND \"CQ_TABLE\"=?");
            params.add(names[0]);
            params.add(names[1]);
            queryUpdateDelete.append(" AND (\"CTC_WRITEID\" > " + tblValidWriteIdList.getHighWatermark());
            queryCompletedCompactions.append(" AND (\"CC_HIGHEST_WRITE_ID\" > " + tblValidWriteIdList.getHighWatermark());
            queryUpdateDelete.append((String)(tblValidWriteIdList.getInvalidWriteIds().length == 0 ? ") " : " OR \"CTC_WRITEID\" IN(" + StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject((long[])tblValidWriteIdList.getInvalidWriteIds()))) + ") ) "));
            queryCompletedCompactions.append((String)(tblValidWriteIdList.getInvalidWriteIds().length == 0 ? ") " : " OR \"CC_HIGHEST_WRITE_ID\" IN(" + StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject((long[])tblValidWriteIdList.getInvalidWriteIds()))) + ") ) "));
            queryUpdateDelete.append(") ");
            queryCompletedCompactions.append(") ");
            queryCompactionQueue.append(") ");
            ++i;
        }
        queryUpdateDelete.append(") AND \"CTC_TXNID\" <= " + currentValidTxnList.getHighWatermark());
        queryUpdateDelete.append((String)(currentValidTxnList.getInvalidTransactions().length == 0 ? " " : " AND \"CTC_TXNID\" NOT IN(" + StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject((long[])currentValidTxnList.getInvalidTransactions()))) + ") "));
        queryCompletedCompactions.append(")");
        queryCompactionQueue.append(") ");
        boolean hasUpdateDelete = this.executeBoolean(jdbcResource, queryUpdateDelete.toString(), params, "Unable to retrieve materialization invalidation information: completed transaction components.");
        queryCompletedCompactions.append(" UNION ");
        queryCompletedCompactions.append(queryCompactionQueue.toString());
        ArrayList<String> paramsTwice = new ArrayList<String>(params);
        paramsTwice.addAll(params);
        boolean hasCompaction = this.executeBoolean(jdbcResource, queryCompletedCompactions.toString(), paramsTwice, "Unable to retrieve materialization invalidation information: compactions");
        return new Materialization(hasUpdateDelete, hasCompaction);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean executeBoolean(MultiDataSourceJdbcResource jdbcResource, String queryText, List<String> params, String errorMessage) throws MetaException {
        try (PreparedStatement pst = jdbcResource.getSqlGenerator().prepareStmtWithParameters(jdbcResource.getConnection(), queryText, params);){
            boolean bl;
            block14: {
                LOG.debug("Going to execute query <{}>", (Object)queryText);
                pst.setMaxRows(1);
                ResultSet rs = pst.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            LOG.warn(errorMessage, (Throwable)ex);
            throw new MetaException(errorMessage + " " + StringUtils.stringifyException((Throwable)ex));
        }
    }
}

