/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class Id
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private static AtomicLong s_nextId = new AtomicLong(System.nanoTime());
    public static final String JSON_CLASS_ID = "org.apache.atlas.typesystem.json.InstanceSerialization$_Id";
    private String id;
    private String typeName;
    private int version;
    private EntityState state;

    public Id() {
    }

    public Id(Id that) {
        if (that != null) {
            this.id = that.id;
            this.typeName = that.typeName;
            this.version = that.version;
            this.state = that.state;
        }
    }

    public Id(String typeName) {
        this("" + Id.nextNegativeLong(), 0, typeName);
    }

    public Id(String id, int version, String typeName) {
        this(id, version, typeName, null);
    }

    public Id(long id, int version, String typeName) {
        this(id, version, typeName, null);
    }

    public Id(long id, int version, String typeName, String state) {
        this("" + id, version, typeName, state);
    }

    public Id(String id, int version, String typeName, String state) {
        this.id = id;
        this.typeName = typeName;
        this.version = version;
        this.state = state == null ? EntityState.ACTIVE : EntityState.valueOf(state.toUpperCase());
    }

    public Id(Map<String, Object> map) {
        this();
        if (map != null) {
            this.id = Id.asString(map.get("id"));
            this.typeName = Id.asString(map.get("typeName"));
            this.version = Id.asInt(map.get("id"));
            this.state = Id.asEntityState(map.get("state"));
        }
    }

    public String getJsonClass() {
        return JSON_CLASS_ID;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public EntityState getState() {
        return this.state;
    }

    public void setState(EntityState state) {
        this.state = state;
    }

    @JsonIgnore
    public String _getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id obj = (Id)o;
        return this.version == obj.version && Objects.equals(this.id, obj.id) && Objects.equals(this.typeName, obj.typeName) && Objects.equals((Object)this.state, (Object)obj.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.typeName, this.version, this.state});
    }

    public String toString() {
        return this.asString(new StringBuilder()).toString();
    }

    public StringBuilder asString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Id{").append("id=").append(this.id).append(", typeName=").append(this.typeName).append(", version=").append(this.version).append(", state=").append((Object)this.state).append("}");
        return sb;
    }

    private static long nextNegativeLong() {
        long ret = s_nextId.getAndDecrement();
        if (ret > 0L) {
            ret *= -1L;
        } else if (ret == 0L) {
            ret = Long.MIN_VALUE;
        }
        return ret;
    }

    static String asString(Object val) {
        return val == null ? null : val.toString();
    }

    static int asInt(Object val) {
        if (val != null) {
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            try {
                return Integer.parseInt(val.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    static Date asDate(Object val) {
        if (val != null) {
            if (val instanceof Date) {
                return (Date)val;
            }
            if (val instanceof Number) {
                return new Date(((Number)val).longValue());
            }
            try {
                return AtlasBaseTypeDef.getDateFormatter().parse(val.toString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    static EntityState asEntityState(Object val) {
        if (val != null) {
            if (val instanceof EntityState) {
                return (EntityState)((Object)val);
            }
            try {
                return EntityState.valueOf(val.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return EntityState.ACTIVE;
    }

    static Map asMap(Object val) {
        return val instanceof Map ? (Map)val : null;
    }

    static List asList(Object val) {
        return val instanceof List ? (List)val : null;
    }

    public static enum EntityState {
        ACTIVE,
        DELETED;

    }
}

