/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import org.datanucleus.flush.SCOOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.scostore.MapStore;
import org.datanucleus.store.types.scostore.Store;

public class MapPutOperation<K, V>
implements SCOOperation {
    final DNStateManager sm;
    final int fieldNumber;
    final MapStore<K, V> store;
    final K key;
    final V value;

    public MapPutOperation(DNStateManager sm, MapStore store, K key, V value) {
        this.sm = sm;
        this.fieldNumber = store.getOwnerMemberMetaData().getAbsoluteFieldNumber();
        this.store = store;
        this.key = key;
        this.value = value;
    }

    public MapPutOperation(DNStateManager sm, int fieldNum, K key, V value) {
        this.sm = sm;
        this.fieldNumber = fieldNum;
        this.store = null;
        this.key = key;
        this.value = value;
    }

    @Override
    public AbstractMemberMetaData getMemberMetaData() {
        return this.store != null ? this.store.getOwnerMemberMetaData() : this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumber);
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void perform() {
        if (this.store != null) {
            this.store.put(this.sm, this.key, this.value);
        }
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public DNStateManager getStateManager() {
        return this.sm;
    }

    public String toString() {
        return "MAP PUT : " + this.sm + " field=" + this.getMemberMetaData().getName();
    }
}

