/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.inmemory;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.util.Localiser;

public class InMemoryQueryResult
extends AbstractList
implements QueryResult,
Serializable {
    private static final long serialVersionUID = 9111768802939625736L;
    ApiAdapter api;
    List results = null;
    protected boolean closed = false;

    public InMemoryQueryResult(List results, ApiAdapter api) {
        this.results = results;
        this.api = api;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean contains(Object o) {
        this.assertIsOpen();
        return this.results.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        this.assertIsOpen();
        return this.results.containsAll(c);
    }

    @Override
    public Object get(int index) {
        this.assertIsOpen();
        return this.results.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.assertIsOpen();
        return this.results.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        this.assertIsOpen();
        return this.results.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        this.assertIsOpen();
        return this.results.lastIndexOf(o);
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        this.assertIsOpen();
        return this.results.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        this.assertIsOpen();
        return this.results.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        this.assertIsOpen();
        return this.results.toArray(a);
    }

    @Override
    public int size() {
        this.assertIsOpen();
        return this.results.size();
    }

    @Override
    public Iterator iterator() {
        Iterator resultIter = this.results.iterator();
        return new ResultIterator(resultIter);
    }

    @Override
    public ListIterator listIterator() {
        ListIterator resultIter = this.results.listIterator();
        return new ResultIterator(resultIter);
    }

    @Override
    public ListIterator listIterator(int index) {
        ListIterator resultIter = this.results.listIterator(index);
        return new ResultIterator(resultIter);
    }

    protected void assertIsOpen() {
        if (this.closed) {
            String msg = Localiser.msg("052600");
            throw this.api.getUserExceptionForException(msg, null);
        }
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException(Localiser.msg("052604"));
    }

    private class ResultIterator
    implements ListIterator {
        Iterator resultIter = null;

        public ResultIterator(Iterator iter) {
            this.resultIter = iter;
        }

        @Override
        public boolean hasNext() {
            if (InMemoryQueryResult.this.closed) {
                return false;
            }
            return this.resultIter.hasNext();
        }

        @Override
        public Object next() {
            if (InMemoryQueryResult.this.closed) {
                throw new NoSuchElementException();
            }
            return this.resultIter.next();
        }

        @Override
        public boolean hasPrevious() {
            if (InMemoryQueryResult.this.closed) {
                return false;
            }
            return ((ListIterator)this.resultIter).hasPrevious();
        }

        public Object previous() {
            if (InMemoryQueryResult.this.closed) {
                throw new NoSuchElementException();
            }
            return ((ListIterator)this.resultIter).previous();
        }

        @Override
        public int nextIndex() {
            return ((ListIterator)this.resultIter).nextIndex();
        }

        @Override
        public int previousIndex() {
            return ((ListIterator)this.resultIter).previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Localiser.msg("052604"));
        }

        public void set(Object e) {
            throw new UnsupportedOperationException(Localiser.msg("052604"));
        }

        public void add(Object e) {
            throw new UnsupportedOperationException(Localiser.msg("052604"));
        }
    }
}

