/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.auth;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RefreshingAuthManager
implements AuthManager {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshingAuthManager.class);
    private final String executorNamePrefix;
    private boolean keepRefreshed = true;
    private volatile ScheduledExecutorService refreshExecutor;

    protected RefreshingAuthManager(String executorNamePrefix) {
        this.executorNamePrefix = executorNamePrefix;
    }

    public void keepRefreshed(boolean keep) {
        this.keepRefreshed = keep;
    }

    @Override
    public void close() {
        ScheduledExecutorService service = this.refreshExecutor;
        this.refreshExecutor = null;
        if (service != null) {
            List<Runnable> tasks = service.shutdownNow();
            tasks.forEach(task -> {
                if (task instanceof Future) {
                    ((Future)((Object)task)).cancel(true);
                }
            });
            try {
                if (!service.awaitTermination(1L, TimeUnit.MINUTES)) {
                    LOG.warn("Timed out waiting for refresh executor to terminate");
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for refresh executor to terminate", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ScheduledExecutorService refreshExecutor() {
        if (!this.keepRefreshed) {
            return null;
        }
        if (this.refreshExecutor == null) {
            RefreshingAuthManager refreshingAuthManager = this;
            synchronized (refreshingAuthManager) {
                if (this.refreshExecutor == null) {
                    this.refreshExecutor = ThreadPools.newScheduledPool(this.executorNamePrefix, 1);
                }
            }
        }
        return this.refreshExecutor;
    }
}

