/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.rename;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.misc.rename.AlterTableRenameDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;

public class AlterTableRenameOperation
extends AbstractAlterTableOperation<AlterTableRenameDesc> {
    public AlterTableRenameOperation(DDLOperationContext context, AlterTableRenameDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        TableName tableName = HiveTableName.of(((AlterTableRenameDesc)this.desc).getDbTableName());
        if (Utils.isBootstrapDumpInProgress(this.context.getDb(), tableName.getDb())) {
            LOG.error("DDLTask: Rename Table not allowed as bootstrap dump in progress");
            throw new HiveException("Rename Table: Not allowed as bootstrap dump in progress");
        }
        return super.execute();
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        HiveTableName.setFrom(((AlterTableRenameDesc)this.desc).getNewName(), table);
    }

    @Override
    protected void checkValidity(Table table, DDLOperationContext context) throws HiveException {
        table.validateName((Configuration)context.getConf());
    }
}

