/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.ShowResourcePlanDesc;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter.ShowResourcePlanFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ShowResourcePlanOperation
extends DDLOperation<ShowResourcePlanDesc> {
    public ShowResourcePlanOperation(DDLOperationContext context, ShowResourcePlanDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, IOException {
        try (DataOutputStream out = ShowUtils.getOutputStream(new Path(((ShowResourcePlanDesc)this.desc).getResFile()), this.context);){
            String resourcePlanName = ((ShowResourcePlanDesc)this.desc).getResourcePlanName();
            ShowResourcePlanFormatter formatter = ShowResourcePlanFormatter.getFormatter(this.context.getConf());
            if (resourcePlanName != null) {
                formatter.showFullResourcePlan(out, this.context.getDb().getResourcePlan(resourcePlanName));
            } else {
                formatter.showResourcePlans(out, this.context.getDb().getAllResourcePlans());
            }
        }
        return 0;
    }
}

