/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class BoundaryCache
extends TreeMap<Integer, Object> {
    private boolean isComplete = false;
    private final int maxSize;
    private final LinkedList<Integer> queue = new LinkedList();

    public BoundaryCache(int maxSize) {
        if (maxSize <= 1) {
            throw new IllegalArgumentException("Cache size of 1 and below it doesn't make sense.");
        }
        this.maxSize = maxSize;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    @Override
    public Object put(Integer key, Object value) {
        Object result = super.put(key, value);
        if (result == null) {
            this.queue.add(key);
        }
        if (this.queue.size() > this.maxSize) {
            this.evictOne();
        }
        return result;
    }

    public Boolean putIfNotFull(Integer key, Object value) {
        if (this.isFull().booleanValue()) {
            return false;
        }
        this.put(key, value);
        return true;
    }

    public Boolean isFull() {
        return this.queue.size() >= this.maxSize;
    }

    @Override
    public void clear() {
        this.isComplete = false;
        this.queue.clear();
        super.clear();
    }

    public Map.Entry<Integer, Object> getMaxEntry() {
        return this.floorEntry(Integer.MAX_VALUE);
    }

    public void evictOne() {
        if (this.queue.isEmpty()) {
            return;
        }
        Integer elementToDelete = this.queue.poll();
        this.remove(elementToDelete);
    }

    public void evictThisAndAllBefore(int rowIdx) {
        while (this.queue.peek() <= rowIdx) {
            this.evictOne();
        }
    }
}

