/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.optimizer.physical.LlapClusterStateForCompile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryInfo {
    private final boolean isTez;
    private final boolean isLlap;
    private final long maxExecutorMemory;
    private final Logger LOG = LoggerFactory.getLogger(MemoryInfo.class);

    public MemoryInfo(Configuration conf) {
        this.isTez = "tez".equalsIgnoreCase(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE));
        this.isLlap = "llap".equalsIgnoreCase(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE));
        if (this.isLlap) {
            LlapClusterStateForCompile llapInfo = LlapClusterStateForCompile.getClusterInfo(conf);
            llapInfo.initClusterInfo();
            if (llapInfo.hasClusterInfo()) {
                this.maxExecutorMemory = llapInfo.getMemoryPerExecutor();
                this.LOG.info("Using LLAP registry executor MB {}", (Object)(this.maxExecutorMemory / 0x100000L));
            } else {
                long memPerInstanceMb = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB);
                this.LOG.info("Using LLAP default executor MB {}", (Object)memPerInstanceMb);
                long numExecutors = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
                this.maxExecutorMemory = memPerInstanceMb * 1024L * 1024L / numExecutors;
            }
        } else if (this.isTez) {
            long containerSizeMb = DagUtils.getContainerResource(conf).getMemorySize();
            float heapFraction = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_CONTAINER_MAX_JAVA_HEAP_FRACTION);
            this.maxExecutorMemory = (long)((float)(containerSizeMb * 1024L * 1024L) * heapFraction);
        } else {
            long executorMemoryFromConf = (long)conf.getInt("mapreduce.map.memory.mb", 1024) * 1024L * 1024L;
            if (executorMemoryFromConf < 0L) {
                this.LOG.warn("Falling back to default container MB {}", (Object)1024);
                this.maxExecutorMemory = 0x40000000L;
            } else {
                this.maxExecutorMemory = executorMemoryFromConf;
            }
        }
    }

    public boolean isTez() {
        return this.isTez;
    }

    public boolean isLlap() {
        return this.isLlap;
    }

    public long getMaxExecutorMemory() {
        return this.maxExecutorMemory;
    }

    public String toString() {
        return "MEMORY INFO - { isTez: " + this.isTez() + ", isLlap: " + this.isLlap() + ", maxExecutorMemory: " + LlapUtil.humanReadableByteCount((long)this.getMaxExecutorMemory()) + " }";
    }
}

