/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.externalize.RelJson;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.JsonBuilder;

public class HiveRelJson
extends RelJson {
    private final JsonBuilder jsonBuilder;

    public HiveRelJson(JsonBuilder jsonBuilder) {
        super(jsonBuilder);
        this.jsonBuilder = jsonBuilder;
    }

    public Object toJson(Object value) {
        if (value instanceof RelDistribution) {
            return this.toJson((RelDistribution)value);
        }
        if (value instanceof RelDataType) {
            return this.toJson((RelDataType)value);
        }
        return super.toJson(value);
    }

    private Object toJson(RelDistribution relDistribution) {
        Map map = this.jsonBuilder.map();
        map.put("type", relDistribution.getType().name());
        if (!relDistribution.getKeys().isEmpty()) {
            ArrayList<Object> keys = new ArrayList<Object>(relDistribution.getKeys().size());
            for (Integer key : relDistribution.getKeys()) {
                keys.add(this.toJson(key));
            }
            map.put("keys", keys);
        }
        return map;
    }

    private Object toJson(RelDataType node) {
        Map map = this.jsonBuilder.map();
        if (node.isStruct()) {
            List list = this.jsonBuilder.list();
            for (RelDataTypeField field : node.getFieldList()) {
                Map mf = (Map)this.toJson(field.getType());
                mf.put("name", field.getName());
                list.add(mf);
            }
            map.put("fields", list);
            map.put("nullable", node.isNullable());
        } else {
            RelDataType valueType;
            RelDataType keyType;
            map.put("type", node.getSqlTypeName().name());
            map.put("nullable", node.isNullable());
            if (node.getComponentType() != null) {
                map.put("component", this.toJson(node.getComponentType()));
            }
            if ((keyType = node.getKeyType()) != null) {
                map.put("key", this.toJson(keyType));
            }
            if ((valueType = node.getValueType()) != null) {
                map.put("value", this.toJson(valueType));
            }
            if (node.getSqlTypeName().allowsPrec()) {
                map.put("precision", node.getPrecision());
            }
            if (node.getSqlTypeName().allowsScale()) {
                map.put("scale", node.getScale());
            }
        }
        return map;
    }
}

