/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAntiJoin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAntiSemiJoinRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveAntiSemiJoinRule.class);
    public static final HiveAntiSemiJoinRule INSTANCE = new HiveAntiSemiJoinRule();

    public HiveAntiSemiJoinRule() {
        super(HiveAntiSemiJoinRule.operand(Project.class, (RelOptRuleOperand)HiveAntiSemiJoinRule.operand(Filter.class, (RelOptRuleOperand)HiveAntiSemiJoinRule.operand(Join.class, (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "HiveJoinWithFilterToAntiJoinRule:filter");
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Filter filter = (Filter)call.rel(1);
        Join join = (Join)call.rel(2);
        this.perform(call, project, filter, join);
    }

    protected void perform(RelOptRuleCall call, Project project, Filter filter, Join join) {
        Project newProject;
        LOG.debug("Start Matching HiveAntiJoinRule");
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        if (join.getJoinType() != JoinRelType.LEFT) {
            return;
        }
        assert (filter != null);
        List<RexNode> filterList = this.getResidualFilterNodes(filter, join);
        if (filterList == null) {
            return;
        }
        boolean hasProjection = HiveCalciteUtil.hasAnyExpressionFromRightSide((RelNode)join, project.getProjects());
        if (hasProjection) {
            return;
        }
        LOG.debug("Matched HiveAntiJoinRule");
        HiveAntiJoin anti = HiveAntiJoin.getAntiJoin(join.getLeft().getCluster(), join.getLeft().getTraitSet(), join.getLeft(), join.getRight(), join.getCondition());
        if (filterList.isEmpty()) {
            newProject = project.copy(project.getTraitSet(), (RelNode)anti, project.getProjects(), project.getRowType());
        } else {
            RexNode condition = filterList.size() == 1 ? filterList.get(0) : join.getCluster().getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, filterList);
            Filter newFilter = filter.copy(filter.getTraitSet(), (RelNode)anti, condition);
            newProject = project.copy(project.getTraitSet(), (RelNode)newFilter, project.getProjects(), project.getRowType());
        }
        call.transformTo((RelNode)newProject);
    }

    private List<RexNode> getResidualFilterNodes(Filter filter, Join join) {
        List aboveFilters = RelOptUtil.conjunctions((RexNode)filter.getCondition());
        boolean hasNullFilterOnRightSide = false;
        ArrayList<RexNode> filterList = new ArrayList<RexNode>();
        for (RexNode filterNode : aboveFilters) {
            if (filterNode.getKind() == SqlKind.IS_NULL) {
                if (HiveCalciteUtil.hasAllExpressionsFromRightSide((RelNode)join, Collections.singletonList(filterNode)) && this.isStrong((RexNode)((RexCall)filterNode).getOperands().get(0))) {
                    hasNullFilterOnRightSide = true;
                    continue;
                }
                filterList.add(filterNode);
                continue;
            }
            if (HiveCalciteUtil.hasAnyExpressionFromRightSide((RelNode)join, Collections.singletonList(filterNode))) {
                return null;
            }
            filterList.add(filterNode);
        }
        if (!hasNullFilterOnRightSide) {
            return null;
        }
        return filterList;
    }

    private boolean isStrong(RexNode rexNode) {
        final AtomicBoolean hasCast = new AtomicBoolean(false);
        rexNode.accept((RexVisitor)new RexVisitorImpl<Void>(true){

            public Void visitCall(RexCall call) {
                if (call.getKind() == SqlKind.CAST) {
                    hasCast.set(true);
                }
                return (Void)super.visitCall(call);
            }
        });
        return !hasCast.get() && Strong.isStrong((RexNode)rexNode);
    }
}

