/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;

public class AlterTableSnapshotRefSpec<T> {
    private final AlterTableType operationType;
    private final T operationParams;

    public AlterTableSnapshotRefSpec(AlterTableType type, T value) {
        this.operationType = type;
        this.operationParams = value;
    }

    public AlterTableType getOperationType() {
        return this.operationType;
    }

    public T getOperationParams() {
        return this.operationParams;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operationType", (Object)this.operationType.name()).add("operationParams", this.operationParams).toString();
    }

    public static class ReplaceSnapshotrefSpec {
        private final String sourceRef;
        private String targetBranch = null;
        private long targetSnapshot;
        boolean replaceBySnapshot = false;
        private long maxRefAgeMs = -1L;
        private int minSnapshotsToKeep = -1;
        private long maxSnapshotAgeMs = -1L;
        private boolean isReplaceBranch;

        public String getSourceRefName() {
            return this.sourceRef;
        }

        public String getTargetBranchName() {
            return this.targetBranch;
        }

        public boolean isReplaceBySnapshot() {
            return this.replaceBySnapshot;
        }

        public long getTargetSnapshot() {
            return this.targetSnapshot;
        }

        public ReplaceSnapshotrefSpec(String sourceRef, String targetBranch) {
            this.sourceRef = sourceRef;
            this.targetBranch = targetBranch;
        }

        public ReplaceSnapshotrefSpec(String sourceRef, long targetSnapshot) {
            this.sourceRef = sourceRef;
            this.targetSnapshot = targetSnapshot;
            this.replaceBySnapshot = true;
        }

        public void setMaxRefAgeMs(long maxRefAgeMs) {
            Preconditions.checkArgument((maxRefAgeMs > 0L ? 1 : 0) != 0);
            this.maxRefAgeMs = maxRefAgeMs;
        }

        public void setMinSnapshotsToKeep(int minSnapshotsToKeep) {
            Preconditions.checkArgument((minSnapshotsToKeep > 0 ? 1 : 0) != 0);
            this.minSnapshotsToKeep = minSnapshotsToKeep;
        }

        public void setMaxSnapshotAgeMs(long maxSnapshotAgeMs) {
            Preconditions.checkArgument((maxSnapshotAgeMs > 0L ? 1 : 0) != 0);
            this.maxSnapshotAgeMs = maxSnapshotAgeMs;
        }

        public long getMaxRefAgeMs() {
            return this.maxRefAgeMs;
        }

        public int getMinSnapshotsToKeep() {
            return this.minSnapshotsToKeep;
        }

        public long getMaxSnapshotAgeMs() {
            return this.maxSnapshotAgeMs;
        }

        public String toString() {
            MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this);
            stringHelper.add("sourceRef", (Object)this.sourceRef);
            stringHelper.add("replace", (Object)(this.isReplaceBranch ? "Branch" : "Tag"));
            if (this.replaceBySnapshot) {
                stringHelper.add("targetSnapshot", this.targetSnapshot);
            } else {
                stringHelper.add("targetBranch", (Object)this.targetBranch);
            }
            if (this.maxRefAgeMs != -1L) {
                stringHelper.add("maxRefAgeMs", this.maxRefAgeMs);
            }
            if (this.minSnapshotsToKeep != -1) {
                stringHelper.add("minSnapshotsToKeep", this.minSnapshotsToKeep);
            }
            if (this.maxSnapshotAgeMs != -1L) {
                stringHelper.add("maxSnapshotAgeMs", this.maxSnapshotAgeMs);
            }
            return stringHelper.toString();
        }

        public void setIsReplaceBranch() {
            this.isReplaceBranch = true;
        }

        public boolean isReplaceBranch() {
            return this.isReplaceBranch;
        }
    }

    public static class RenameSnapshotrefSpec {
        private final String sourceBranch;
        private final String targetBranch;

        public String getSourceBranchName() {
            return this.sourceBranch;
        }

        public String getTargetBranchName() {
            return this.targetBranch;
        }

        public RenameSnapshotrefSpec(String sourceBranch, String targetBranch) {
            this.sourceBranch = sourceBranch;
            this.targetBranch = targetBranch;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sourceBranch", (Object)this.sourceBranch).add("targetBranch", (Object)this.targetBranch).toString();
        }
    }

    public static class DropSnapshotRefSpec {
        private final String refName;
        private final boolean ifExists;

        public String getRefName() {
            return this.refName;
        }

        public boolean getIfExists() {
            return this.ifExists;
        }

        public DropSnapshotRefSpec(String refName, Boolean ifExists) {
            this.refName = refName;
            this.ifExists = ifExists;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("refName", (Object)this.refName).add("ifExists", this.ifExists).toString();
        }
    }

    public static class CreateSnapshotRefSpec {
        private String refName;
        private Long snapshotId;
        private Long asOfTime;
        private Long maxRefAgeMs;
        private Integer minSnapshotsToKeep;
        private Long maxSnapshotAgeMs;
        private String asOfTag;
        private boolean isReplace;
        private boolean ifNotExists;

        public String getRefName() {
            return this.refName;
        }

        public Long getSnapshotId() {
            return this.snapshotId;
        }

        public Long getAsOfTime() {
            return this.asOfTime;
        }

        public Long getMaxRefAgeMs() {
            return this.maxRefAgeMs;
        }

        public Integer getMinSnapshotsToKeep() {
            return this.minSnapshotsToKeep;
        }

        public Long getMaxSnapshotAgeMs() {
            return this.maxSnapshotAgeMs;
        }

        public String getAsOfTag() {
            return this.asOfTag;
        }

        public boolean isReplace() {
            return this.isReplace;
        }

        public boolean isIfNotExists() {
            return this.ifNotExists;
        }

        public CreateSnapshotRefSpec(String refName, Long snapShotId, Long asOfTime, Long maxRefAgeMs, Integer minSnapshotsToKeep, Long maxSnapshotAgeMs, String asOfTag, boolean isReplace, boolean ifNotExists) {
            this.refName = refName;
            this.snapshotId = snapShotId;
            this.asOfTime = asOfTime;
            this.maxRefAgeMs = maxRefAgeMs;
            this.minSnapshotsToKeep = minSnapshotsToKeep;
            this.maxSnapshotAgeMs = maxSnapshotAgeMs;
            this.asOfTag = asOfTag;
            this.isReplace = isReplace;
            this.ifNotExists = ifNotExists;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("refName", (Object)this.refName).add("snapshotId", (Object)this.snapshotId).add("asOfTime", (Object)this.asOfTime).add("maxRefAgeMs", (Object)this.maxRefAgeMs).add("minSnapshotsToKeep", (Object)this.minSnapshotsToKeep).add("maxSnapshotAgeMs", (Object)this.maxSnapshotAgeMs).add("isReplace", this.isReplace).add("ifNotExists", this.ifNotExists).omitNullValues().toString();
        }
    }
}

