/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.drop.DropTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.UpdatedMetaDataTracker;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.DeferredWorkContext;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.OutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(ImportSemanticAnalyzer.class);
    private boolean tableExists = false;

    public ImportSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    public boolean existsTable() {
        return this.tableExists;
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        try {
            Tree fromTree = ast.getChild(0);
            boolean isLocationSet = false;
            boolean isExternalSet = false;
            boolean isPartSpecSet = false;
            String parsedLocation = null;
            String parsedTableName = null;
            String parsedDbName = null;
            LinkedHashMap<String, String> parsedPartSpec = new LinkedHashMap<String, String>();
            boolean waitOnPrecursor = false;
            block8: for (int i = 1; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                switch (child.getToken().getType()) {
                    case 145: {
                        isExternalSet = true;
                        continue block8;
                    }
                    case 1254: {
                        isLocationSet = true;
                        parsedLocation = EximUtil.relativeToAbsolutePath(this.conf, ImportSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                        continue block8;
                    }
                    case 1243: {
                        ASTNode tableNameNode = (ASTNode)child.getChild(0);
                        Map.Entry<String, String> dbTablePair = ImportSemanticAnalyzer.getDbTableNamePair(tableNameNode);
                        parsedDbName = dbTablePair.getKey();
                        parsedTableName = dbTablePair.getValue();
                        if (child.getChildCount() != 2) continue block8;
                        ASTNode partspec = (ASTNode)child.getChild(1);
                        isPartSpecSet = true;
                        this.parsePartitionSpec(child, parsedPartSpec);
                    }
                }
            }
            if (StringUtils.isEmpty(parsedDbName)) {
                parsedDbName = SessionState.get().getCurrentDatabase();
            }
            EximUtil.SemanticAnalyzerWrapperContext x = new EximUtil.SemanticAnalyzerWrapperContext(this.conf, this.db, this.inputs, this.outputs, this.rootTasks, LOG, this.ctx);
            MetaData rv = EximUtil.getMetaDataFromLocation(fromTree.getText(), x.getConf());
            this.tableExists = this.prepareImport(true, isLocationSet, isExternalSet, isPartSpecSet, waitOnPrecursor, parsedLocation, parsedTableName, parsedDbName, parsedPartSpec, fromTree.getText(), x, null, this.getTxnMgr(), 0L, rv);
        }
        catch (SemanticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.IMPORT_SEMANTIC_ERROR.getMsg(), (Throwable)e);
        }
    }

    private void parsePartitionSpec(ASTNode tableNode, LinkedHashMap<String, String> partSpec) throws SemanticException {
        if (tableNode.getChildCount() == 2) {
            ASTNode partspec = (ASTNode)tableNode.getChild(1);
            for (int j = 0; j < partspec.getChildCount(); ++j) {
                ASTNode partspec_val = (ASTNode)partspec.getChild(j);
                String val = null;
                String colName = ImportSemanticAnalyzer.unescapeIdentifier(partspec_val.getChild(0).getText().toLowerCase());
                if (partspec_val.getChildCount() < 2) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Dynamic partitions not allowed"));
                }
                val = ImportSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                partSpec.put(colName, val);
            }
        }
    }

    private boolean prepareImport(boolean isImportCmd, boolean isLocationSet, boolean isExternalSet, boolean isPartSpecSet, boolean waitOnPrecursor, String parsedLocation, String parsedTableName, String overrideDBName, LinkedHashMap<String, String> parsedPartSpec, String fromLocn, EximUtil.SemanticAnalyzerWrapperContext x, UpdatedMetaDataTracker updatedMetadata, HiveTxnManager txnMgr, long writeId, MetaData rv) throws IOException, MetaException, HiveException, URISyntaxException {
        if (!isExternalSet) {
            this.queryState.getValidTxnList();
        }
        return ImportSemanticAnalyzer.prepareImport(isImportCmd, isLocationSet, isExternalSet, isPartSpecSet, waitOnPrecursor, parsedLocation, parsedTableName, overrideDBName, parsedPartSpec, fromLocn, x, updatedMetadata, txnMgr, writeId, rv, null, null);
    }

    public static boolean prepareImport(boolean isImportCmd, boolean isLocationSet, boolean isExternalSet, boolean isPartSpecSet, boolean waitOnPrecursor, String parsedLocation, String parsedTableName, String overrideDBName, LinkedHashMap<String, String> parsedPartSpec, String fromLocn, EximUtil.SemanticAnalyzerWrapperContext x, UpdatedMetaDataTracker updatedMetadata, HiveTxnManager txnMgr, long writeId, MetaData rv, String dumpRoot, ReplicationMetricCollector metricCollector) throws IOException, MetaException, HiveException, URISyntaxException {
        ImportTableDesc tblDesc;
        URI fromURI = EximUtil.getValidatedURI(x.getConf(), ImportSemanticAnalyzer.stripQuotes(fromLocn));
        Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
        FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)x.getConf());
        x.getInputs().add(ImportSemanticAnalyzer.toReadEntity(fromPath, x.getConf()));
        if (rv.getTable() == null) {
            return false;
        }
        ReplicationSpec replicationSpec = rv.getReplicationSpec();
        if (replicationSpec.isNoop()) {
            x.getLOG().debug("Current update with ID:{} is noop", (Object)replicationSpec.getCurrentReplicationState());
            return false;
        }
        if (isImportCmd) {
            replicationSpec.setReplSpecType(ReplicationSpec.Type.IMPORT);
        }
        String dbname = rv.getTable().getDbName();
        if (overrideDBName != null && !overrideDBName.isEmpty()) {
            dbname = overrideDBName;
        }
        org.apache.hadoop.hive.metastore.api.Table tblObj = rv.getTable();
        try {
            tblDesc = ImportSemanticAnalyzer.getBaseCreateTableDescFromTable(dbname, tblObj);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        boolean inReplicationScope = false;
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            tblDesc.setReplicationSpec(replicationSpec);
            inReplicationScope = true;
            tblDesc.setReplWriteId(writeId);
            tblDesc.setOwnerName(tblObj.getOwner());
        }
        if (isExternalSet) {
            tblDesc.setExternal(isExternalSet);
        }
        if (isLocationSet) {
            STATIC_LOG.debug("table {} location is {}", (Object)tblDesc.getTableName(), (Object)parsedLocation);
            tblDesc.setLocation(parsedLocation);
            x.getInputs().add(ImportSemanticAnalyzer.toReadEntity(new Path(parsedLocation), x.getConf()));
        }
        if (StringUtils.isNotBlank((CharSequence)parsedTableName)) {
            tblDesc.setTableName(TableName.fromString((String)parsedTableName, null, (String)dbname));
        }
        if (tblDesc.getTableName() == null) {
            throw new SemanticException(ErrorMsg.NEED_TABLE_SPECIFICATION.getMsg());
        }
        x.getConf().set("import.destination.table", tblDesc.getTableName());
        ArrayList<AlterTableAddPartitionDesc> partitionDescs = new ArrayList<AlterTableAddPartitionDesc>();
        Iterable<org.apache.hadoop.hive.metastore.api.Partition> partitions = rv.getPartitions();
        for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
            AlterTableAddPartitionDesc partsDesc = ImportSemanticAnalyzer.getBaseAddPartitionDescFromPartition(fromPath, dbname, tblDesc, partition, replicationSpec, x.getConf());
            partitionDescs.add(partsDesc);
        }
        if (isPartSpecSet) {
            boolean found = false;
            ListIterator partnIter = partitionDescs.listIterator();
            while (partnIter.hasNext()) {
                AlterTableAddPartitionDesc addPartitionDesc = (AlterTableAddPartitionDesc)partnIter.next();
                if (!found && addPartitionDesc.getPartitions().get(0).getPartSpec().equals(parsedPartSpec)) {
                    found = true;
                    continue;
                }
                partnIter.remove();
            }
            if (!found) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(" - Specified partition not found in import directory"));
            }
        }
        Warehouse wh = new Warehouse((Configuration)x.getConf());
        Table table = ImportSemanticAnalyzer.tableIfExists(tblDesc, x.getHive());
        boolean tableExists = false;
        if (table != null) {
            ImportSemanticAnalyzer.checkTable(table, tblDesc, replicationSpec, x.getConf());
            x.getLOG().debug("table " + tblDesc.getTableName() + " exists: metadata checked");
            tableExists = true;
        }
        if (!tableExists && isExternalSet) {
            AcidUtils.setNonTransactional(tblDesc.getTblProps());
        }
        int stmtId = 0;
        if (!replicationSpec.isInReplicationScope() && (tableExists && AcidUtils.isTransactionalTable(table) || !tableExists && AcidUtils.isTablePropertyTransactional(tblDesc.getTblProps())) && x.getCtx().getExplainConfig() == null && !inReplicationScope) {
            writeId = txnMgr.getTableWriteId(tblDesc.getDatabaseName(), tblDesc.getTableName());
            stmtId = txnMgr.getStmtIdAndIncrement();
        }
        if (inReplicationScope) {
            ImportSemanticAnalyzer.createReplImportTasks(tblDesc, partitionDescs, replicationSpec, waitOnPrecursor, table, fromURI, wh, x, writeId, stmtId, updatedMetadata, dumpRoot, metricCollector);
        } else {
            ImportSemanticAnalyzer.createRegularImportTasks(tblDesc, partitionDescs, isPartSpecSet, replicationSpec, table, fromURI, fs, wh, x, writeId, stmtId);
        }
        return tableExists;
    }

    private static AlterTableAddPartitionDesc getBaseAddPartitionDescFromPartition(Path fromPath, String dbName, ImportTableDesc tblDesc, org.apache.hadoop.hive.metastore.api.Partition partition, ReplicationSpec replicationSpec, HiveConf conf) throws MetaException, SemanticException {
        Map<String, String> partitionSpec = EximUtil.makePartSpec(tblDesc.getPartCols(), partition.getValues());
        StorageDescriptor sd = partition.getSd();
        String location = null;
        if (replicationSpec.isInReplicationScope() && tblDesc.isExternal()) {
            location = ReplExternalTables.externalTableLocation(conf, partition.getSd().getLocation());
            LOG.debug("partition {} has data location: {}", (Object)partition, (Object)location);
        } else {
            location = new Path(fromPath, Warehouse.makePartName(tblDesc.getPartCols(), (List)partition.getValues())).toString();
        }
        long writeId = -1L;
        if (tblDesc.getReplWriteId() != null) {
            writeId = tblDesc.getReplWriteId();
        }
        AlterTableAddPartitionDesc.PartitionDesc partitionDesc = new AlterTableAddPartitionDesc.PartitionDesc(partitionSpec, location, partition.getParameters(), sd.getInputFormat(), sd.getOutputFormat(), sd.getNumBuckets(), sd.getCols(), sd.getSerdeInfo().getSerializationLib(), sd.getSerdeInfo().getParameters(), sd.getBucketCols(), sd.getSortCols(), null, writeId);
        return new AlterTableAddPartitionDesc(dbName, tblDesc.getTableName(), true, (List<AlterTableAddPartitionDesc.PartitionDesc>)ImmutableList.of((Object)partitionDesc));
    }

    private static ImportTableDesc getBaseCreateTableDescFromTable(String dbName, org.apache.hadoop.hive.metastore.api.Table tblObj) throws Exception {
        Table table = new Table(tblObj);
        return new ImportTableDesc(dbName, table);
    }

    private static Task<?> loadTable(URI fromURI, ImportTableDesc tblDesc, boolean replace, Path tgtPath, ReplicationSpec replicationSpec, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId) throws HiveException {
        return ImportSemanticAnalyzer.loadTable(fromURI, tblDesc, replace, tgtPath, replicationSpec, x, writeId, stmtId, null, null);
    }

    public static void setupDeferredContextFromMetadata(DeferredWorkContext deferredContext) throws HiveException {
        deferredContext.table = ImportSemanticAnalyzer.tableIfExists(deferredContext.tblDesc, deferredContext.hive);
        if (deferredContext.table == null) {
            deferredContext.table = ImportSemanticAnalyzer.createNewTableMetadataObject(deferredContext.tblDesc, true);
        }
        if (deferredContext.inReplScope) {
            deferredContext.isSkipTrash = MetaStoreUtils.isSkipTrash(deferredContext.table.getParameters());
            if (deferredContext.table.isTemporary()) {
                deferredContext.needRecycle = false;
            } else {
                Database db = deferredContext.hive.getDatabase(deferredContext.table.getDbName());
                boolean bl = deferredContext.needRecycle = db != null && ReplChangeManager.shouldEnableCm((Database)db, (org.apache.hadoop.hive.metastore.api.Table)deferredContext.table.getTTable());
            }
        }
        if (AcidUtils.isTransactionalTable(deferredContext.table)) {
            String mmSubdir = deferredContext.replace ? AcidUtils.baseDir(deferredContext.writeId) : AcidUtils.deltaSubdir(deferredContext.writeId, deferredContext.writeId, deferredContext.stmtId);
            deferredContext.destPath = new Path(deferredContext.tgtPath, mmSubdir);
            deferredContext.loadPath = deferredContext.tgtPath;
            deferredContext.loadFileType = LoadTableDesc.LoadFileType.KEEP_EXISTING;
        } else {
            deferredContext.destPath = deferredContext.loadPath = deferredContext.ctx.getExternalTmpPath(deferredContext.tgtPath);
            deferredContext.loadFileType = deferredContext.replace ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING;
        }
        deferredContext.isCalculated = true;
    }

    private static Task<?> loadTable(URI fromURI, ImportTableDesc tblDesc, boolean replace, Path tgtPath, ReplicationSpec replicationSpec, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId, String dumpRoot, ReplicationMetricCollector metricCollector) throws HiveException {
        Task<CopyWork> copyTask;
        Path dataPath = new Path(fromURI.toString(), "data");
        DeferredWorkContext resolver = new DeferredWorkContext(replace, tgtPath, writeId, stmtId, x.getHive(), x.getCtx(), tblDesc, replicationSpec.isInReplicationScope());
        if (replicationSpec.isInReplicationScope()) {
            boolean copyAtLoad = x.getConf().getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
            copyTask = ReplCopyTask.getLoadCopyTask(replicationSpec, dataPath, null, x.getConf(), false, false, copyAtLoad, dumpRoot, metricCollector);
        } else {
            copyTask = TaskFactory.get(new CopyWork(dataPath, null, false, dumpRoot, metricCollector, true));
        }
        copyTask.setDeferredWorkContext(resolver);
        MoveWork moveWork = new MoveWork(x.getInputs(), x.getOutputs(), null, null, false, dumpRoot, metricCollector, true);
        Task<MoveWork> loadTableTask = TaskFactory.get(moveWork, x.getConf());
        loadTableTask.setDeferredWorkContext(resolver);
        copyTask.addDependentTask(loadTableTask);
        x.getTasks().add(copyTask);
        return loadTableTask;
    }

    private static Task<?> createTableTask(ImportTableDesc tableDesc, EximUtil.SemanticAnalyzerWrapperContext x) {
        return tableDesc.getCreateTableTask(x.getInputs(), x.getOutputs(), x.getConf());
    }

    private static Task<?> createTableTask(ImportTableDesc tableDesc, EximUtil.SemanticAnalyzerWrapperContext x, String dumpRoot, ReplicationMetricCollector metricCollector) {
        return tableDesc.getCreateTableTask(x.getInputs(), x.getOutputs(), x.getConf(), true, dumpRoot, metricCollector, false);
    }

    private static Task<?> dropTableTask(Table table, EximUtil.SemanticAnalyzerWrapperContext x, ReplicationSpec replicationSpec) {
        DropTableDesc dropTblDesc = new DropTableDesc(table.getTableName(), true, false, replicationSpec);
        return TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), dropTblDesc), x.getConf());
    }

    private static Task<?> dropTableTask(Table table, EximUtil.SemanticAnalyzerWrapperContext x, ReplicationSpec replicationSpec, String dumpRoot, ReplicationMetricCollector metricCollector) {
        DropTableDesc dropTblDesc = new DropTableDesc(table.getTableName(), true, false, replicationSpec);
        return TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), dropTblDesc, true, dumpRoot, metricCollector), x.getConf());
    }

    private static Task<?> alterTableTask(ImportTableDesc tableDesc, EximUtil.SemanticAnalyzerWrapperContext x, ReplicationSpec replicationSpec) {
        tableDesc.setReplaceMode(true);
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            tableDesc.setReplicationSpec(replicationSpec);
        }
        return tableDesc.getCreateTableTask(x.getInputs(), x.getOutputs(), x.getConf());
    }

    private static Task<?> alterTableTask(ImportTableDesc tableDesc, EximUtil.SemanticAnalyzerWrapperContext x, ReplicationSpec replicationSpec, boolean isReplication, String dumpRoot, ReplicationMetricCollector metricCollector) {
        tableDesc.setReplaceMode(true);
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            tableDesc.setReplicationSpec(replicationSpec);
        }
        return tableDesc.getCreateTableTask(x.getInputs(), x.getOutputs(), x.getConf(), isReplication, dumpRoot, metricCollector, false);
    }

    private static Task<?> alterSinglePartition(ImportTableDesc tblDesc, Table table, Warehouse wh, AlterTableAddPartitionDesc addPartitionDesc, ReplicationSpec replicationSpec, Partition ptn, EximUtil.SemanticAnalyzerWrapperContext x) throws MetaException, IOException, HiveException {
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            addPartitionDesc.setReplicationSpec(replicationSpec);
        }
        AlterTableAddPartitionDesc.PartitionDesc partSpec = addPartitionDesc.getPartitions().get(0);
        if (ptn == null) {
            ImportSemanticAnalyzer.fixLocationInPartSpec(tblDesc, table, wh, replicationSpec, partSpec, x);
        } else if (!ImportSemanticAnalyzer.externalTablePartition(tblDesc, replicationSpec)) {
            partSpec.setLocation(ptn.getLocation());
        }
        return TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), addPartitionDesc), x.getConf());
    }

    private static Task<?> alterSinglePartition(ImportTableDesc tblDesc, Table table, Warehouse wh, AlterTableAddPartitionDesc addPartitionDesc, ReplicationSpec replicationSpec, Partition ptn, EximUtil.SemanticAnalyzerWrapperContext x, boolean isReplication, String dumpRoot, ReplicationMetricCollector metricCollector) throws MetaException, IOException, HiveException {
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            addPartitionDesc.setReplicationSpec(replicationSpec);
        }
        AlterTableAddPartitionDesc.PartitionDesc partSpec = addPartitionDesc.getPartitions().get(0);
        if (ptn == null) {
            ImportSemanticAnalyzer.fixLocationInPartSpec(tblDesc, table, wh, replicationSpec, partSpec, x);
        } else if (!ImportSemanticAnalyzer.externalTablePartition(tblDesc, replicationSpec)) {
            partSpec.setLocation(ptn.getLocation());
        }
        return TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), addPartitionDesc, isReplication, dumpRoot, metricCollector), x.getConf());
    }

    private static Task<?> addSinglePartition(ImportTableDesc tblDesc, Table table, Warehouse wh, AlterTableAddPartitionDesc addPartitionDesc, ReplicationSpec replicationSpec, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId) throws MetaException, IOException, HiveException {
        return ImportSemanticAnalyzer.addSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, false, null, null);
    }

    private static Task<?> addSinglePartition(ImportTableDesc tblDesc, Table table, Warehouse wh, AlterTableAddPartitionDesc addPartitionDesc, ReplicationSpec replicationSpec, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId, boolean isReplication, String dumpRoot, ReplicationMetricCollector metricCollector) throws MetaException, IOException, HiveException {
        Path moveTaskSrc;
        Path destPath;
        LoadTableDesc.LoadFileType loadFileType;
        AlterTableAddPartitionDesc.PartitionDesc partSpec = addPartitionDesc.getPartitions().get(0);
        boolean isSkipTrash = false;
        boolean needRecycle = false;
        if (ImportSemanticAnalyzer.shouldSkipDataCopyInReplScope(tblDesc, replicationSpec) || tblDesc.isExternal() && tblDesc.getLocation() == null) {
            x.getLOG().debug("Adding AddPart and skipped data copy for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()));
            Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), addPartitionDesc, isReplication, dumpRoot, metricCollector), x.getConf());
            return addPartTask;
        }
        String srcLocation = partSpec.getLocation();
        if (replicationSpec.isInReplicationScope() && !ReplicationSpec.Type.IMPORT.equals((Object)replicationSpec.getReplSpecType())) {
            Path partLocation = new Path(partSpec.getLocation());
            Path dataDirBase = partLocation.getParent();
            Object bucketDir = partLocation.getName();
            for (int i = 1; i < partSpec.getPartSpec().size(); ++i) {
                bucketDir = dataDirBase.getName() + File.separator + (String)bucketDir;
                dataDirBase = dataDirBase.getParent();
            }
            String relativePartDataPath = "data" + File.separator + (String)bucketDir;
            srcLocation = new Path(dataDirBase, relativePartDataPath).toString();
        }
        ImportSemanticAnalyzer.fixLocationInPartSpec(tblDesc, table, wh, replicationSpec, partSpec, x);
        x.getLOG().debug("adding dependent CopyWork/AddPart/MoveWork for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()) + " with source location: " + srcLocation);
        Path tgtLocation = new Path(partSpec.getLocation());
        if (replicationSpec.isInReplicationScope()) {
            Database db;
            loadFileType = LoadTableDesc.LoadFileType.IGNORE;
            destPath = tgtLocation;
            isSkipTrash = MetaStoreUtils.isSkipTrash(table.getParameters());
            needRecycle = table.isTemporary() ? false : (db = x.getHive().getDatabase(table.getDbName())) != null && ReplChangeManager.shouldEnableCm((Database)db, (org.apache.hadoop.hive.metastore.api.Table)table.getTTable());
        } else {
            loadFileType = replicationSpec.isReplace() ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING;
            boolean useStagingDirectory = !AcidUtils.isTransactionalTable(table.getParameters()) || replicationSpec.isInReplicationScope();
            destPath = useStagingDirectory ? x.getCtx().getExternalTmpPath(tgtLocation) : new Path(tgtLocation, AcidUtils.deltaSubdir(writeId, writeId, stmtId));
        }
        Path path = moveTaskSrc = !AcidUtils.isTransactionalTable(table.getParameters()) || replicationSpec.isInReplicationScope() ? destPath : tgtLocation;
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("adding import work for partition with source location: " + srcLocation + "; target: " + tgtLocation + "; copy dest " + destPath + "; mm " + writeId + " for " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()) + ": " + (AcidUtils.isFullAcidTable(table) ? "acid" : (AcidUtils.isInsertOnlyTable(table) ? "mm" : "flat")));
        }
        Task<CopyWork> copyTask = null;
        if (replicationSpec.isInReplicationScope()) {
            boolean copyAtLoad = x.getConf().getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
            copyTask = ReplCopyTask.getLoadCopyTask(replicationSpec, new Path(srcLocation), destPath, x.getConf(), isSkipTrash, needRecycle, copyAtLoad, dumpRoot, metricCollector);
        } else {
            copyTask = TaskFactory.get(new CopyWork(new Path(srcLocation), destPath, false, dumpRoot, metricCollector, isReplication));
        }
        Task<DDLWork> addPartTask = null;
        if (x.getEventType() != DumpType.EVENT_COMMIT_TXN) {
            addPartTask = TaskFactory.get(new DDLWork(x.getInputs(), x.getOutputs(), addPartitionDesc, isReplication, dumpRoot, metricCollector), x.getConf());
        }
        MoveWork moveWork = new MoveWork(x.getInputs(), x.getOutputs(), null, null, false, dumpRoot, metricCollector, isReplication);
        if (replicationSpec.isInReplicationScope() && AcidUtils.isTransactionalTable(tblDesc.getTblProps())) {
            LoadMultiFilesDesc loadFilesWork = new LoadMultiFilesDesc(Collections.singletonList(destPath), Collections.singletonList(tgtLocation), true, null, null);
            moveWork.setMultiFilesDesc(loadFilesWork);
            moveWork.setNeedCleanTarget(replicationSpec.isReplace());
        } else {
            LoadTableDesc loadTableWork = new LoadTableDesc(moveTaskSrc, Utilities.getTableDesc(table), partSpec.getPartSpec(), loadFileType, writeId);
            loadTableWork.setStmtId(stmtId);
            loadTableWork.setInheritTableSpecs(false);
            moveWork.setLoadTableWork(loadTableWork);
        }
        if (loadFileType == LoadTableDesc.LoadFileType.IGNORE) {
            if (x.getEventType() == DumpType.EVENT_INSERT) {
                copyTask.addDependentTask(TaskFactory.get(moveWork, x.getConf()));
            } else if (addPartTask != null) {
                copyTask.addDependentTask(addPartTask);
            }
            return copyTask;
        }
        Task<MoveWork> loadPartTask = TaskFactory.get(moveWork, x.getConf());
        copyTask.addDependentTask(loadPartTask);
        if (addPartTask != null) {
            addPartTask.addDependentTask(loadPartTask);
            x.getTasks().add(copyTask);
            return addPartTask;
        }
        return copyTask;
    }

    private static boolean shouldSkipDataCopyInReplScope(ImportTableDesc tblDesc, ReplicationSpec replicationSpec) {
        return replicationSpec != null && replicationSpec.isInReplicationScope() && tblDesc.isExternal();
    }

    private static void fixLocationInPartSpec(ImportTableDesc tblDesc, Table table, Warehouse wh, ReplicationSpec replicationSpec, AlterTableAddPartitionDesc.PartitionDesc partSpec, EximUtil.SemanticAnalyzerWrapperContext x) throws MetaException, HiveException, IOException {
        if (ImportSemanticAnalyzer.externalTablePartition(tblDesc, replicationSpec)) {
            return;
        }
        Path tableLocation = ImportSemanticAnalyzer.getTableDataLocation(wh, table, tblDesc, x);
        Path tgtPath = new Path(tableLocation, Warehouse.makePartPath(partSpec.getPartSpec()));
        FileSystem tgtFs = FileSystem.get((URI)tgtPath.toUri(), (Configuration)x.getConf());
        ImportSemanticAnalyzer.checkTargetLocationEmpty(tgtFs, tgtPath, replicationSpec, x.getLOG());
        partSpec.setLocation(tgtPath.toString());
    }

    private static boolean externalTablePartition(ImportTableDesc tblDesc, ReplicationSpec replicationSpec) {
        return replicationSpec != null && replicationSpec.isInReplicationScope() && tblDesc.isExternal();
    }

    public static void checkTargetLocationEmpty(FileSystem fs, Path targetPath, ReplicationSpec replicationSpec, Logger logger) throws IOException, SemanticException {
        FileStatus[] status;
        if (replicationSpec.isInReplicationScope()) {
            return;
        }
        logger.debug("checking emptiness of " + targetPath.toString());
        if (fs.exists(targetPath) && (status = fs.listStatus(targetPath, FileUtils.HIDDEN_FILES_PATH_FILTER)).length > 0) {
            logger.debug("Files inc. " + status[0].getPath().toString() + " found in path : " + targetPath.toString());
            throw new SemanticException(ErrorMsg.TABLE_DATA_EXISTS.getMsg());
        }
    }

    public static String partSpecToString(Map<String, String> partSpec) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Map.Entry<String, String> entry : partSpec.entrySet()) {
            if (!firstTime) {
                sb.append(',');
            }
            firstTime = false;
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private static void checkTable(Table table, ImportTableDesc tableDesc, ReplicationSpec replicationSpec, HiveConf conf) throws SemanticException, URISyntaxException {
        String importedSerde;
        Map<String, String> importedTableParams;
        if (replicationSpec.isInReplicationScope()) {
            return;
        }
        if (table.getParameters().containsKey(ReplicationSpec.KEY.CURR_STATE_ID_SOURCE.toString()) && conf.getBoolVar(HiveConf.ConfVars.HIVE_EXIM_RESTRICT_IMPORTS_INTO_REPLICATED_TABLES)) {
            throw new SemanticException(ErrorMsg.IMPORT_INTO_STRICT_REPL_TABLE.getMsg("Table " + table.getTableName() + " has repl.last.id parameter set."));
        }
        EximUtil.validateTable(table);
        if (!(!tableDesc.isExternal() || table.isPartitioned() && table.getTableType().equals((Object)TableType.EXTERNAL_TABLE))) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" External table cannot overwrite existing table. Drop existing table first."));
        }
        if (tableDesc.getLocation() != null && !table.isPartitioned() && !table.getDataLocation().equals((Object)new Path(tableDesc.getLocation()))) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Location does not match"));
        }
        List<FieldSchema> existingTableCols = table.getCols();
        List<FieldSchema> importedTableCols = tableDesc.getCols();
        if (!EximUtil.schemaCompare(importedTableCols, existingTableCols)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Column Schema does not match"));
        }
        List<FieldSchema> existingTablePartCols = table.getPartCols();
        List<FieldSchema> importedTablePartCols = tableDesc.getPartCols();
        if (!EximUtil.schemaCompare(importedTablePartCols, existingTablePartCols)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Partition Schema does not match"));
        }
        Map<String, String> existingTableParams = table.getParameters();
        String error = ImportSemanticAnalyzer.checkParams(existingTableParams, importedTableParams = tableDesc.getTblProps(), new String[]{"howl.isd", "howl.osd"});
        if (error != null) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table parameters do not match: " + error));
        }
        String existingifc = table.getInputFormatClass().getName();
        String importedifc = tableDesc.getInputFormat();
        String existingofc = table.getOutputFormatClass().getName();
        String importedofc = tableDesc.getOutputFormat();
        try {
            Class<?> origin = Class.forName(importedofc, true, Utilities.getSessionSpecifiedClassLoader());
            Class<? extends OutputFormat> replaced = HiveFileFormatUtils.getOutputFormatSubstitute(origin);
            if (replaced == null) {
                throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
            }
            importedofc = replaced.getCanonicalName();
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
        }
        if (!existingifc.equals(importedifc) || !existingofc.equals(importedofc)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table inputformat/outputformats do not match"));
        }
        String existingSerde = table.getSerializationLib();
        if (!existingSerde.equals(importedSerde = tableDesc.getSerName())) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table Serde class does not match"));
        }
        String existingSerdeFormat = table.getSerdeParam("serialization.format");
        String importedSerdeFormat = tableDesc.getSerdeProps().get("serialization.format");
        String string = importedSerdeFormat = importedSerdeFormat == null ? "1" : importedSerdeFormat;
        if (!TxnUtils.isTransactionalTable(table.getParameters()) && !ObjectUtils.equals((Object)existingSerdeFormat, (Object)importedSerdeFormat)) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table Serde format does not match. Imported : " + importedSerdeFormat + " existing: " + existingSerdeFormat));
        }
        if (!ObjectUtils.equals(table.getBucketCols(), tableDesc.getBucketCols())) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table bucketing spec does not match"));
        }
        List<Order> existingOrder = table.getSortCols();
        List<Order> importedOrder = tableDesc.getSortCols();
        if (existingOrder != null) {
            if (importedOrder != null) {
                final class OrderComparator
                implements Comparator<Order> {
                    OrderComparator() {
                    }

                    @Override
                    public int compare(Order o1, Order o2) {
                        if (o1.getOrder() < o2.getOrder()) {
                            return -1;
                        }
                        if (o1.getOrder() == o2.getOrder()) {
                            return 0;
                        }
                        return 1;
                    }
                }
                Collections.sort(existingOrder, new OrderComparator());
                Collections.sort(importedOrder, new OrderComparator());
                if (!existingOrder.equals(importedOrder)) {
                    throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table sorting spec does not match"));
                }
            }
        } else if (importedOrder != null) {
            throw new SemanticException(ErrorMsg.INCOMPATIBLE_SCHEMA.getMsg(" Table sorting spec does not match"));
        }
    }

    private static String checkParams(Map<String, String> map1, Map<String, String> map2, String[] keys) {
        block6: {
            block5: {
                if (map1 == null) break block5;
                if (map2 != null) {
                    for (String key : keys) {
                        String v2;
                        String v1 = map1.get(key);
                        if (ObjectUtils.equals((Object)v1, (Object)(v2 = map2.get(key)))) continue;
                        return "Mismatch for " + key;
                    }
                } else {
                    for (String key : keys) {
                        if (map1.get(key) == null) continue;
                        return "Mismatch for " + key;
                    }
                }
                break block6;
            }
            if (map2 == null) break block6;
            for (String key : keys) {
                if (map2.get(key) == null) continue;
                return "Mismatch for " + key;
            }
        }
        return null;
    }

    private static void createRegularImportTasks(ImportTableDesc tblDesc, List<AlterTableAddPartitionDesc> partitionDescs, boolean isPartSpecSet, ReplicationSpec replicationSpec, Table table, URI fromURI, FileSystem fs, Warehouse wh, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId) throws HiveException, IOException, MetaException {
        if (table != null) {
            if (table.isPartitioned()) {
                x.getLOG().debug("table partitioned");
                for (AlterTableAddPartitionDesc addPartitionDesc : partitionDescs) {
                    Map<String, String> partSpec = addPartitionDesc.getPartitions().get(0).getPartSpec();
                    Partition ptn = null;
                    ptn = x.getHive().getPartition(table, partSpec, false);
                    if (ptn == null) {
                        x.getTasks().add(ImportSemanticAnalyzer.addSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, false, null, null));
                        continue;
                    }
                    throw new SemanticException(ErrorMsg.PARTITION_EXISTS.getMsg(ImportSemanticAnalyzer.partSpecToString(partSpec)));
                }
            } else {
                x.getLOG().debug("table non-partitioned");
                Path tgtPath = new Path(table.getDataLocation().toString());
                FileSystem tgtFs = FileSystem.get((URI)tgtPath.toUri(), (Configuration)x.getConf());
                ImportSemanticAnalyzer.checkTargetLocationEmpty(tgtFs, tgtPath, replicationSpec, x.getLOG());
                ImportSemanticAnalyzer.loadTable(fromURI, tblDesc, false, tgtPath, replicationSpec, x, writeId, stmtId);
            }
            x.getOutputs().add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
        } else {
            x.getLOG().debug("table " + tblDesc.getTableName() + " does not exist");
            Task<?> t = ImportSemanticAnalyzer.createTableTask(tblDesc, x);
            table = ImportSemanticAnalyzer.createNewTableMetadataObject(tblDesc, false);
            Database parentDb = x.getHive().getDatabase(tblDesc.getDatabaseName());
            x.getOutputs().add(new WriteEntity(parentDb, WriteEntity.WriteType.DDL_SHARED));
            if (ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
                for (AlterTableAddPartitionDesc addPartitionDesc : partitionDescs) {
                    t.addDependentTask(ImportSemanticAnalyzer.addSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, false, null, null));
                }
            } else {
                x.getLOG().debug("adding dependent CopyWork/MoveWork for table");
                if (tblDesc.isExternal() && tblDesc.getLocation() == null) {
                    x.getLOG().debug("Importing in place, no emptiness check, no copying/loading");
                    Path dataPath = new Path(fromURI.toString(), "data");
                    tblDesc.setLocation(dataPath.toString());
                } else {
                    Path tablePath = ImportSemanticAnalyzer.getTableDataLocation(wh, table, tblDesc, x);
                    FileSystem tgtFs = FileSystem.get((URI)tablePath.toUri(), (Configuration)x.getConf());
                    ImportSemanticAnalyzer.checkTargetLocationEmpty(tgtFs, tablePath, replicationSpec, x.getLOG());
                    t.addDependentTask(ImportSemanticAnalyzer.loadTable(fromURI, tblDesc, false, tablePath, replicationSpec, x, writeId, stmtId));
                }
            }
            x.getTasks().add(t);
        }
    }

    public static Table createNewTableMetadataObject(ImportTableDesc tblDesc, boolean isRepl) throws SemanticException {
        Table newTable = new Table(tblDesc.getDatabaseName(), tblDesc.getTableName());
        newTable.setParameters(tblDesc.getTblProps());
        if (tblDesc.isExternal() && AcidUtils.isTransactionalTable(newTable)) {
            if (isRepl) {
                throw new SemanticException("External tables may not be transactional: " + Warehouse.getQualifiedName((String)tblDesc.getDatabaseName(), (String)tblDesc.getTableName()));
            }
            throw new AssertionError((Object)("Internal error: transactional properties not set properly" + tblDesc.getTblProps()));
        }
        return newTable;
    }

    private static void createReplImportTasks(ImportTableDesc tblDesc, List<AlterTableAddPartitionDesc> partitionDescs, ReplicationSpec replicationSpec, boolean waitOnPrecursor, Table table, URI fromURI, Warehouse wh, EximUtil.SemanticAnalyzerWrapperContext x, Long writeId, int stmtId, UpdatedMetaDataTracker updatedMetadata, String dumpRoot, ReplicationMetricCollector metricCollector) throws HiveException, IOException, MetaException {
        boolean firstIncPending;
        Task<?> dropTblTask = null;
        WriteEntity.WriteType lockType = WriteEntity.WriteType.DDL_NO_LOCK;
        Database parentDb = x.getHive().getDatabase(tblDesc.getDatabaseName());
        if (parentDb == null) {
            if (!waitOnPrecursor) {
                throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(tblDesc.getDatabaseName()));
            }
            firstIncPending = false;
        } else {
            firstIncPending = ReplUtils.isFirstIncPending(parentDb.getParameters());
        }
        if (table != null) {
            if (!replicationSpec.allowReplacementInto(parentDb.getParameters())) {
                x.getLOG().info("Table {}.{} is not replaced as it is newer than the update", (Object)tblDesc.getDatabaseName(), (Object)tblDesc.getTableName());
                return;
            }
            if (x.getEventType() == DumpType.EVENT_CREATE_TABLE) {
                dropTblTask = ImportSemanticAnalyzer.dropTableTask(table, x, replicationSpec, dumpRoot, metricCollector);
                table = null;
            } else if (!firstIncPending) {
                firstIncPending = ReplUtils.isFirstIncPending(table.getParameters());
            }
        } else if (parentDb != null && !replicationSpec.allowReplacementInto(parentDb.getParameters())) {
            x.getLOG().info("Table {}.{} is not created as the database is newer than the update", (Object)tblDesc.getDatabaseName(), (Object)tblDesc.getTableName());
            return;
        }
        replicationSpec.setNeedDupCopyCheck(firstIncPending);
        if (updatedMetadata != null) {
            updatedMetadata.set(replicationSpec.getReplicationState(), tblDesc.getDatabaseName(), tblDesc.getTableName(), null);
        }
        if (tblDesc.getLocation() == null) {
            if (parentDb != null && !tblDesc.isExternal() && StringUtils.isNotBlank((CharSequence)parentDb.getManagedLocationUri())) {
                tblDesc.setLocation(new Path(parentDb.getManagedLocationUri(), tblDesc.getTableName()).toString());
                LOG.info("Setting the location for table {} as {}", (Object)tblDesc.getTableName(), (Object)tblDesc.getLocation());
            } else if (!waitOnPrecursor) {
                tblDesc.setLocation(wh.getDefaultTablePath(parentDb, tblDesc.getTableName(), tblDesc.isExternal()).toString());
            } else {
                tblDesc.setLocation(wh.getDnsPath(wh.getDefaultTablePath(tblDesc.getDatabaseName(), tblDesc.getTableName(), tblDesc.isExternal())).toString());
            }
        }
        if (table == null) {
            if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                lockType = WriteEntity.WriteType.DDL_SHARED;
            }
            table = ImportSemanticAnalyzer.createNewTableMetadataObject(tblDesc, true);
            List<Task<?>> dependentTasks = null;
            if (ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
                dependentTasks = new ArrayList(partitionDescs.size());
                for (AlterTableAddPartitionDesc addPartitionDesc : partitionDescs) {
                    addPartitionDesc.setReplicationSpec(replicationSpec);
                    if (!replicationSpec.isMetadataOnly()) {
                        dependentTasks.add(ImportSemanticAnalyzer.addSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, true, dumpRoot, metricCollector));
                    } else {
                        dependentTasks.add(ImportSemanticAnalyzer.alterSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, null, x, true, dumpRoot, metricCollector));
                    }
                    if (updatedMetadata == null) continue;
                    updatedMetadata.addPartition(table.getDbName(), table.getTableName(), addPartitionDesc.getPartitions().get(0).getPartSpec());
                }
            } else if (!replicationSpec.isMetadataOnly() && !ImportSemanticAnalyzer.shouldSkipDataCopyInReplScope(tblDesc, replicationSpec)) {
                x.getLOG().debug("adding dependent CopyWork/MoveWork for table");
                dependentTasks = Collections.singletonList(ImportSemanticAnalyzer.loadTable(fromURI, tblDesc, replicationSpec.isReplace(), new Path(tblDesc.getLocation()), replicationSpec, x, writeId, stmtId, dumpRoot, metricCollector));
            }
            if (x.getEventType() != DumpType.EVENT_COMMIT_TXN) {
                if (x.getEventType() == DumpType.EVENT_CREATE_TABLE && !tblDesc.isExternal()) {
                    tblDesc.setLocation(null);
                }
                Task<?> t = ImportSemanticAnalyzer.createTableTask(tblDesc, x, dumpRoot, metricCollector);
                if (dependentTasks != null) {
                    dependentTasks.forEach(task -> t.addDependentTask((Task<?>)task));
                }
                if (dropTblTask != null) {
                    dropTblTask.addDependentTask(t);
                    x.getTasks().add(dropTblTask);
                } else {
                    x.getTasks().add(t);
                }
            } else {
                assert (dropTblTask == null);
                if (dependentTasks != null) {
                    x.getTasks().addAll(dependentTasks);
                }
            }
        } else {
            boolean isOldTableValid = true;
            if (table.isPartitioned() != ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
                table = ImportSemanticAnalyzer.createNewTableMetadataObject(tblDesc, true);
                isOldTableValid = false;
            }
            if (ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
                x.getLOG().debug("table partitioned");
                for (AlterTableAddPartitionDesc addPartitionDesc : partitionDescs) {
                    addPartitionDesc.setReplicationSpec(replicationSpec);
                    Map<String, String> partSpec = addPartitionDesc.getPartitions().get(0).getPartSpec();
                    Partition ptn = null;
                    if (isOldTableValid) {
                        try {
                            ptn = x.getHive().getPartition(table, partSpec, false);
                        }
                        catch (HiveException ex) {
                            ptn = null;
                            table = ImportSemanticAnalyzer.createNewTableMetadataObject(tblDesc, true);
                            isOldTableValid = false;
                        }
                    }
                    if (ptn == null) {
                        if (!replicationSpec.isMetadataOnly()) {
                            x.getTasks().add(ImportSemanticAnalyzer.addSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, true, dumpRoot, metricCollector));
                            if (updatedMetadata == null) continue;
                            updatedMetadata.addPartition(table.getDbName(), table.getTableName(), partSpec);
                            continue;
                        }
                        x.getTasks().add(ImportSemanticAnalyzer.alterSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, null, x, true, dumpRoot, metricCollector));
                        if (updatedMetadata == null) continue;
                        updatedMetadata.addPartition(table.getDbName(), table.getTableName(), partSpec);
                        continue;
                    }
                    if (!replicationSpec.allowReplacementInto(parentDb.getParameters())) continue;
                    if (!replicationSpec.isMetadataOnly()) {
                        x.getTasks().add(ImportSemanticAnalyzer.addSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, x, writeId, stmtId, true, dumpRoot, metricCollector));
                    } else {
                        x.getTasks().add(ImportSemanticAnalyzer.alterSinglePartition(tblDesc, table, wh, addPartitionDesc, replicationSpec, ptn, x, true, dumpRoot, metricCollector));
                    }
                    if (updatedMetadata != null) {
                        updatedMetadata.addPartition(table.getDbName(), table.getTableName(), partSpec);
                    }
                    if (lockType != WriteEntity.WriteType.DDL_NO_LOCK) continue;
                    lockType = WriteEntity.WriteType.DDL_SHARED;
                }
                if (replicationSpec.isMetadataOnly() && partitionDescs.isEmpty()) {
                    x.getTasks().add(ImportSemanticAnalyzer.alterTableTask(tblDesc, x, replicationSpec, true, dumpRoot, metricCollector));
                    if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                        lockType = WriteEntity.WriteType.DDL_SHARED;
                    }
                }
            } else {
                x.getLOG().debug("table non-partitioned");
                if (!replicationSpec.isMetadataOnly()) {
                    ImportSemanticAnalyzer.loadTable(fromURI, tblDesc, replicationSpec.isReplace(), new Path(tblDesc.getLocation()), replicationSpec, x, writeId, stmtId, dumpRoot, metricCollector);
                } else {
                    x.getTasks().add(ImportSemanticAnalyzer.alterTableTask(tblDesc, x, replicationSpec, true, dumpRoot, metricCollector));
                }
                if (lockType == WriteEntity.WriteType.DDL_NO_LOCK) {
                    lockType = WriteEntity.WriteType.DDL_SHARED;
                }
            }
        }
        x.getOutputs().add(new WriteEntity(table, lockType));
    }

    public static boolean isPartitioned(ImportTableDesc tblDesc) {
        return tblDesc.getPartCols() != null && !tblDesc.getPartCols().isEmpty();
    }

    public static Table tableIfExists(ImportTableDesc tblDesc, Hive db) throws HiveException {
        try {
            return db.getTable(tblDesc.getDatabaseName(), tblDesc.getTableName());
        }
        catch (InvalidTableException e) {
            return null;
        }
    }

    private static Path getTableDataLocation(Warehouse wh, Table destTable, ImportTableDesc tblDesc, EximUtil.SemanticAnalyzerWrapperContext x) throws HiveException, MetaException {
        if (tblDesc.getLocation() != null) {
            return new Path(tblDesc.getLocation());
        }
        if (destTable != null && destTable.getDataLocation() != null) {
            return destTable.getDataLocation();
        }
        Table translatedTable = x.getHive().getTranslateTableDryrun(tblDesc.toTable(x.getConf()).getTTable());
        Path tablePath = translatedTable.getDataLocation();
        if (tablePath == null) {
            Database parentDb = x.getHive().getDatabase(tblDesc.getDatabaseName());
            tablePath = wh.getDefaultTablePath(parentDb, tblDesc.getTableName(), tblDesc.isExternal());
        }
        return tablePath;
    }
}

