/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.metadata.HiveException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EventsDumpMetadata {
    @JsonProperty
    private Long lastReplId;
    @JsonProperty
    private Integer eventsDumpedCount;
    @JsonProperty
    private boolean eventsBatched;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public EventsDumpMetadata() {
    }

    public EventsDumpMetadata(Long lastReplId, Integer eventsDumpedCount, boolean eventsBatched) {
        this.lastReplId = lastReplId;
        this.eventsDumpedCount = eventsDumpedCount;
        this.eventsBatched = eventsBatched;
    }

    public Long getLastReplId() {
        return this.lastReplId;
    }

    public Integer getEventsDumpedCount() {
        return this.eventsDumpedCount;
    }

    public void setLastReplId(Long lastReplId) {
        this.lastReplId = lastReplId;
    }

    public void setEventsDumpedCount(Integer eventsDumpedCount) {
        this.eventsDumpedCount = eventsDumpedCount;
    }

    public void incrementEventsDumpedCount() {
        Integer n = this.eventsDumpedCount;
        this.eventsDumpedCount = this.eventsDumpedCount + 1;
    }

    public boolean isEventsBatched() {
        return this.eventsBatched;
    }

    public void setEventsBatched(boolean eventsBatched) {
        this.eventsBatched = eventsBatched;
    }

    public String serialize() throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)this);
    }

    public static EventsDumpMetadata deserialize(Path ackFile, HiveConf conf) throws HiveException {
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).build();
        try {
            return retryable.executeCallable(() -> {
                FileSystem fs = ackFile.getFileSystem((Configuration)conf);
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(ackFile), Charset.defaultCharset()));){
                    EventsDumpMetadata eventsDumpMetadata = (EventsDumpMetadata)objectMapper.readValue((Reader)br, EventsDumpMetadata.class);
                    return eventsDumpMetadata;
                }
            });
        }
        catch (Exception e) {
            throw new HiveException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), (Throwable)e);
        }
    }
}

