/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedPartFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.RowWisePartWriter;
import org.apache.flink.util.Preconditions;

@Internal
public class RowWiseBucketWriter<IN, BucketID>
extends OutputStreamBasedPartFileWriter.OutputStreamBasedBucketWriter<IN, BucketID> {
    private final Encoder<IN> encoder;

    public RowWiseBucketWriter(RecoverableWriter recoverableWriter, Encoder<IN> encoder) {
        super(recoverableWriter);
        this.encoder = encoder;
    }

    @Override
    public InProgressFileWriter<IN, BucketID> resumeFrom(BucketID bucketId, RecoverableFsDataOutputStream stream, Path path, RecoverableWriter.ResumeRecoverable resumable, long creationTime) {
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)resumable);
        return new RowWisePartWriter<IN, BucketID>(bucketId, path, stream, this.encoder, creationTime);
    }

    @Override
    public InProgressFileWriter<IN, BucketID> openNew(BucketID bucketId, RecoverableFsDataOutputStream stream, Path path, long creationTime) {
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)path);
        return new RowWisePartWriter<IN, BucketID>(bucketId, path, stream, this.encoder, creationTime);
    }
}

