/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManagerBase;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFile;
import org.apache.flink.runtime.state.CheckpointedStateScope;

public class WithinCheckpointFileMergingSnapshotManager
extends FileMergingSnapshotManagerBase {
    private static final FileMergingSnapshotManager.SubtaskKey DUMMY_SUBTASK_KEY = new FileMergingSnapshotManager.SubtaskKey("dummy", -1, -1);
    private final Map<Tuple3<Long, FileMergingSnapshotManager.SubtaskKey, CheckpointedStateScope>, PhysicalFile> writablePhysicalFilePool = new HashMap<Tuple3<Long, FileMergingSnapshotManager.SubtaskKey, CheckpointedStateScope>, PhysicalFile>();

    public WithinCheckpointFileMergingSnapshotManager(String id, Executor ioExecutor) {
        super(id, ioExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected PhysicalFile getOrCreatePhysicalFileForCheckpoint(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointId, CheckpointedStateScope scope) throws IOException {
        PhysicalFile file;
        Tuple3 fileKey = Tuple3.of((Object)checkpointId, (Object)(scope == CheckpointedStateScope.SHARED ? subtaskKey : DUMMY_SUBTASK_KEY), (Object)((Object)scope));
        Map<Tuple3<Long, FileMergingSnapshotManager.SubtaskKey, CheckpointedStateScope>, PhysicalFile> map = this.writablePhysicalFilePool;
        synchronized (map) {
            file = this.writablePhysicalFilePool.remove(fileKey);
            if (file == null) {
                file = this.createPhysicalFile(subtaskKey, scope);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void returnPhysicalFileForNextReuse(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointId, PhysicalFile physicalFile) throws IOException {
        FSDataOutputStream os;
        PhysicalFile current;
        CheckpointedStateScope scope = physicalFile.getScope();
        Tuple3 fileKey = Tuple3.of((Object)checkpointId, (Object)(scope == CheckpointedStateScope.SHARED ? subtaskKey : DUMMY_SUBTASK_KEY), (Object)((Object)scope));
        Map<Tuple3<Long, FileMergingSnapshotManager.SubtaskKey, CheckpointedStateScope>, PhysicalFile> map = this.writablePhysicalFilePool;
        synchronized (map) {
            current = this.writablePhysicalFilePool.putIfAbsent((Tuple3<Long, FileMergingSnapshotManager.SubtaskKey, CheckpointedStateScope>)fileKey, physicalFile);
        }
        if (this.shouldSyncAfterClosingLogicalFile && (os = physicalFile.getOutputStream()) != null) {
            os.sync();
        }
        if (current != null && current != physicalFile) {
            physicalFile.close();
        }
    }
}

